/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ssdb4j.pool;

import java.io.IOException;
import org.apache.commons.pool.ObjectPool;
import org.nutz.ssdb4j.spi.Cmd;
import org.nutz.ssdb4j.spi.Response;
import org.nutz.ssdb4j.spi.SSDBException;
import org.nutz.ssdb4j.spi.SSDBStream;
import org.nutz.ssdb4j.spi.SSDBStreamCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolSSDBStream
implements SSDBStream {
    protected ObjectPool<SSDBStream> pool;

    public PoolSSDBStream(ObjectPool<SSDBStream> pool) {
        this.pool = pool;
    }

    @Override
    public Response req(Cmd cmd, byte[] ... vals) {
        SSDBStream steam = null;
        try {
            steam = (SSDBStream)this.pool.borrowObject();
            Response resp = steam.req(cmd, vals);
            this.pool.returnObject((Object)steam);
            return resp;
        }
        catch (Exception e) {
            if (steam != null) {
                try {
                    this.pool.invalidateObject((Object)steam);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            throw new SSDBException(e);
        }
    }

    @Override
    public void callback(SSDBStreamCallback callback) {
        try {
            SSDBStream steam = (SSDBStream)this.pool.borrowObject();
            try {
                steam.callback(callback);
            }
            finally {
                this.pool.returnObject((Object)steam);
            }
        }
        catch (Exception e) {
            throw new SSDBException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.pool.close();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }
}

