/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ssdb4j.spi;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nutz.ssdb4j.SSDBs;
import org.nutz.ssdb4j.spi.SSDBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Response {
    public String stat;
    public ArrayList<byte[]> datas = new ArrayList(2);
    public Charset charset = SSDBs.DEFAULT_CHARSET;

    public Response check() {
        if (!this.ok()) {
            throw new SSDBException("msg=" + this.stat + ", values=" + this.listString());
        }
        return this;
    }

    public boolean ok() {
        return "ok".equals(this.stat);
    }

    public boolean notFound() {
        return "not_found".equals(this.stat);
    }

    protected String _string(byte[] data) {
        return new String(data, this.charset);
    }

    public String asString() {
        return this._string(this.datas.get(0));
    }

    public double asDouble() {
        return Double.parseDouble(this.asString());
    }

    public int asInt() {
        return Integer.parseInt(this.asString());
    }

    public long asLong() {
        return Long.parseLong(this.asString());
    }

    public List<String> listString() {
        ArrayList<String> list = new ArrayList<String>();
        for (byte[] data : this.datas) {
            list.add(this._string(data));
        }
        return list;
    }

    public Map<String, Object> map() {
        if (this.datas.size() % 2 != 0) {
            throw new IllegalArgumentException("not key-value pairs");
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Iterator<byte[]> it = this.datas.iterator();
        while (it.hasNext()) {
            map.put(this._string(it.next()), it.next());
        }
        return map;
    }

    public Map<String, String> mapString() {
        if (this.datas.size() % 2 != 0) {
            throw new IllegalArgumentException("not key-value pairs");
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Iterator<byte[]> it = this.datas.iterator();
        while (it.hasNext()) {
            map.put(this._string(it.next()), this._string(it.next()));
        }
        return map;
    }
}

