/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jta.atomikos;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.jta.atomikos.AtomikosLoggingLevel;

@ConfigurationProperties(value="spring.jta.atomikos.properties")
public class AtomikosProperties {
    private final Map<String, String> values = new TreeMap<String, String>();
    private String service;
    private long maxTimeout = 300000L;
    private long defaultJtaTimeout = 10000L;
    private int maxActives = 50;
    private boolean enableLogging = true;
    private String transactionManagerUniqueName;
    private boolean serialJtaTransactions = true;
    private boolean forceShutdownOnVmExit;
    private String logBaseName = "tmlog";
    private String logBaseDir;
    private long checkpointInterval = 500L;
    private AtomikosLoggingLevel consoleLogLevel = AtomikosLoggingLevel.WARN;
    private String outputDir;
    private String consoleFileName = "tm.out";
    private int consoleFileCount = 1;
    private int consoleFileLimit = -1;
    private boolean threadedTwoPhaseCommit = true;

    public void setService(String service) {
        this.service = service;
        this.set("service", service);
    }

    public String getService() {
        return this.service;
    }

    public void setMaxTimeout(long maxTimeout) {
        this.maxTimeout = maxTimeout;
        this.set("max_timeout", maxTimeout);
    }

    public long getMaxTimeout() {
        return this.maxTimeout;
    }

    public void setDefaultJtaTimeout(long defaultJtaTimeout) {
        this.defaultJtaTimeout = defaultJtaTimeout;
        this.set("default_jta_timeout", defaultJtaTimeout);
    }

    public long getDefaultJtaTimeout() {
        return this.defaultJtaTimeout;
    }

    public void setMaxActives(int maxActives) {
        this.maxActives = maxActives;
        this.set("max_actives", maxActives);
    }

    public int getMaxActives() {
        return this.maxActives;
    }

    public void setEnableLogging(boolean enableLogging) {
        this.enableLogging = enableLogging;
        this.set("enable_logging", enableLogging);
    }

    public boolean isEnableLogging() {
        return this.enableLogging;
    }

    public void setTransactionManagerUniqueName(String uniqueName) {
        this.transactionManagerUniqueName = uniqueName;
        this.set("tm_unique_name", uniqueName);
    }

    public String getTransactionManagerUniqueName() {
        return this.transactionManagerUniqueName;
    }

    public void setSerialJtaTransactions(boolean serialJtaTransactions) {
        this.serialJtaTransactions = serialJtaTransactions;
        this.set("serial_jta_transactions", serialJtaTransactions);
    }

    public boolean isSerialJtaTransactions() {
        return this.serialJtaTransactions;
    }

    public void setForceShutdownOnVmExit(boolean forceShutdownOnVmExit) {
        this.forceShutdownOnVmExit = forceShutdownOnVmExit;
        this.set("force_shutdown_on_vm_exit", forceShutdownOnVmExit);
    }

    public boolean isForceShutdownOnVmExit() {
        return this.forceShutdownOnVmExit;
    }

    public void setLogBaseName(String logBaseName) {
        this.logBaseName = logBaseName;
        this.set("log_base_name", logBaseName);
    }

    public String getLogBaseName() {
        return this.logBaseName;
    }

    public void setLogBaseDir(String logBaseDir) {
        this.logBaseDir = logBaseDir;
        this.set("log_base_dir", logBaseDir);
    }

    public String getLogBaseDir() {
        return this.logBaseDir;
    }

    public void setCheckpointInterval(long checkpointInterval) {
        this.checkpointInterval = checkpointInterval;
        this.set("checkpoint_interval", checkpointInterval);
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    @Deprecated
    public void setConsoleLogLevel(AtomikosLoggingLevel consoleLogLevel) {
        this.consoleLogLevel = consoleLogLevel;
        this.set("console_log_level", (Object)consoleLogLevel);
    }

    @DeprecatedConfigurationProperty(reason="The proprietary logging framework is no longer supported as of Atomikos 3.8")
    @Deprecated
    public AtomikosLoggingLevel getConsoleLogLevel() {
        return this.consoleLogLevel;
    }

    @Deprecated
    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
        this.set("output_dir", outputDir);
    }

    @DeprecatedConfigurationProperty(reason="The proprietary logging framework is no longer supported as of Atomikos 3.8")
    @Deprecated
    public String getOutputDir() {
        return this.outputDir;
    }

    @Deprecated
    public void setConsoleFileName(String consoleFileName) {
        this.consoleFileName = consoleFileName;
        this.set("console_file_name", consoleFileName);
    }

    @DeprecatedConfigurationProperty(reason="The proprietary logging framework is no longer supported as of Atomikos 3.8")
    @Deprecated
    public String getConsoleFileName() {
        return this.consoleFileName;
    }

    @Deprecated
    public void setConsoleFileCount(int consoleFileCount) {
        this.consoleFileCount = consoleFileCount;
        this.set("console_file_count", consoleFileCount);
    }

    @DeprecatedConfigurationProperty(reason="The proprietary logging framework is no longer supported as of Atomikos 3.8")
    @Deprecated
    public int getConsoleFileCount() {
        return this.consoleFileCount;
    }

    @Deprecated
    public void setConsoleFileLimit(int consoleFileLimit) {
        this.consoleFileLimit = consoleFileLimit;
        this.set("console_file_limit", consoleFileLimit);
    }

    @DeprecatedConfigurationProperty(reason="The proprietary logging framework is no longer supported as of Atomikos 3.8")
    @Deprecated
    public int getConsoleFileLimit() {
        return this.consoleFileLimit;
    }

    public void setThreadedTwoPhaseCommit(boolean threadedTwoPhaseCommit) {
        this.threadedTwoPhaseCommit = threadedTwoPhaseCommit;
        this.set("threaded_2pc", threadedTwoPhaseCommit);
    }

    public boolean isThreadedTwoPhaseCommit() {
        return this.threadedTwoPhaseCommit;
    }

    private void set(String key, Object value) {
        this.set("com.atomikos.icatch.", key, value);
    }

    private void set(String keyPrefix, String key, Object value) {
        if (value != null) {
            this.values.put(keyPrefix + key, value.toString());
        } else {
            this.values.remove(keyPrefix + key);
        }
    }

    public Properties asProperties() {
        Properties properties = new Properties();
        properties.putAll(this.values);
        return properties;
    }
}

