/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.aggregations.Aggregation;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.dao.DataAccessException;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.elasticsearch.BulkFailureException;
import org.springframework.data.elasticsearch.NoSuchIndexException;
import org.springframework.data.elasticsearch.UncategorizedElasticsearchException;
import org.springframework.data.elasticsearch.client.reactive.ReactiveElasticsearchClient;
import org.springframework.data.elasticsearch.core.ElasticsearchExceptionTranslator;
import org.springframework.data.elasticsearch.core.EntityOperations;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.RequestFactory;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHitMapping;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.convert.MappingElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.document.DocumentAdapters;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.event.ReactiveAfterConvertCallback;
import org.springframework.data.elasticsearch.core.event.ReactiveAfterSaveCallback;
import org.springframework.data.elasticsearch.core.event.ReactiveBeforeConvertCallback;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.mapping.SimpleElasticsearchMappingContext;
import org.springframework.data.elasticsearch.core.query.BulkOptions;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.SeqNoPrimaryTerm;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.elasticsearch.support.VersionInfo;
import org.springframework.data.mapping.callback.ReactiveEntityCallbacks;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class ReactiveElasticsearchTemplate
implements ReactiveElasticsearchOperations,
ApplicationContextAware {
    private static final Logger QUERY_LOGGER = LoggerFactory.getLogger((String)"org.springframework.data.elasticsearch.core.QUERY");
    private final ReactiveElasticsearchClient client;
    private final ElasticsearchConverter converter;
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;
    private final ElasticsearchExceptionTranslator exceptionTranslator;
    private final EntityOperations operations;
    protected RequestFactory requestFactory;
    @Nullable
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.IMMEDIATE;
    @Nullable
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpenAndForbidClosedIgnoreThrottled();
    @Nullable
    private ReactiveEntityCallbacks entityCallbacks;

    public ReactiveElasticsearchTemplate(ReactiveElasticsearchClient client) {
        this(client, new MappingElasticsearchConverter((MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty>)new SimpleElasticsearchMappingContext()));
    }

    public ReactiveElasticsearchTemplate(ReactiveElasticsearchClient client, ElasticsearchConverter converter) {
        Assert.notNull((Object)client, (String)"client must not be null");
        Assert.notNull((Object)converter, (String)"converter must not be null");
        this.client = client;
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
        this.exceptionTranslator = new ElasticsearchExceptionTranslator();
        this.operations = new EntityOperations(this.mappingContext);
        this.requestFactory = new RequestFactory(converter);
        this.logVersions();
    }

    private void logVersions() {
        this.getClusterVersion().doOnSuccess(VersionInfo::logVersions).doOnError(e -> VersionInfo.logVersions(null)).subscribe();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.entityCallbacks == null) {
            this.setEntityCallbacks(ReactiveEntityCallbacks.create((BeanFactory)applicationContext));
        }
    }

    public void setEntityCallbacks(ReactiveEntityCallbacks entityCallbacks) {
        Assert.notNull((Object)entityCallbacks, (String)"EntityCallbacks must not be null!");
        this.entityCallbacks = entityCallbacks;
    }

    @Override
    public <T> Mono<T> save(T entity, IndexCoordinates index) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        return this.maybeCallBeforeConvert(entity, index).flatMap(entityAfterBeforeConversionCallback -> this.doIndex(entityAfterBeforeConversionCallback, index)).map(it -> {
            Object savedEntity = it.getT1();
            IndexResponse indexResponse = (IndexResponse)it.getT2();
            EntityOperations.AdaptibleEntity<Object> adaptableEntity = this.operations.forEntity(savedEntity, this.converter.getConversionService());
            return adaptableEntity.populateIdIfNecessary(indexResponse.getId());
        }).flatMap(saved -> this.maybeCallAfterSave(saved, index));
    }

    @Override
    public <T> Mono<T> save(T entity) {
        return this.save(entity, this.getIndexCoordinatesFor(entity.getClass()));
    }

    @Override
    public <T> Flux<T> saveAll(Mono<? extends Collection<? extends T>> entitiesPublisher, IndexCoordinates index) {
        Assert.notNull(entitiesPublisher, (String)"Entities must not be null!");
        return entitiesPublisher.flatMapMany(entities -> Flux.fromIterable((Iterable)entities).concatMap(entity -> this.maybeCallBeforeConvert(entity, index))).collectList().map(x$0 -> new Entities((List)x$0)).flatMapMany(entities -> {
            if (((Entities)entities).isEmpty()) {
                return Flux.empty();
            }
            return this.doBulkOperation(((Entities)entities).indexQueries(), BulkOptions.defaultOptions(), index).index().flatMap(indexAndResponse -> {
                Object savedEntity = ((Entities)entities).entityAt((Long)indexAndResponse.getT1());
                BulkItemResponse bulkItemResponse = (BulkItemResponse)indexAndResponse.getT2();
                EntityOperations.AdaptibleEntity<Object> adaptibleEntity = this.operations.forEntity(savedEntity, this.converter.getConversionService());
                adaptibleEntity.populateIdIfNecessary(bulkItemResponse.getResponse().getId());
                return this.maybeCallAfterSave(savedEntity, index);
            });
        });
    }

    @Override
    public <T> Flux<T> multiGet(Query query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"Index must not be null");
        Assert.notNull(clazz, (String)"Class must not be null");
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notEmpty(query.getIds(), (String)"No Id define for Query");
        ReadDocumentCallback callback = new ReadDocumentCallback(this.converter, clazz, index);
        MultiGetRequest request = this.requestFactory.multiGetRequest(query, index);
        return Flux.from(this.execute(client -> client.multiGet(request))).concatMap(result -> callback.doWith(DocumentAdapters.from(result)));
    }

    @Override
    public Mono<Void> bulkUpdate(List<UpdateQuery> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        Assert.notNull(queries, (String)"List of UpdateQuery must not be null");
        Assert.notNull((Object)bulkOptions, (String)"BulkOptions must not be null");
        Assert.notNull((Object)index, (String)"Index must not be null");
        return this.doBulkOperation(queries, bulkOptions, index).then();
    }

    protected Mono<IndexResponse> doIndex(IndexRequest request) {
        return Mono.from(this.execute(client -> client.index(request)));
    }

    protected Flux<BulkItemResponse> doBulkOperation(List<?> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        BulkRequest bulkRequest = this.prepareWriteRequest(this.requestFactory.bulkRequest(queries, bulkOptions, index));
        return this.client.bulk(bulkRequest).onErrorMap(e -> new UncategorizedElasticsearchException("Error while bulk for request: " + bulkRequest.toString(), (Throwable)e)).flatMap(this::checkForBulkOperationFailure).flatMapMany(response -> Flux.fromArray((Object[])response.getItems()));
    }

    protected Mono<BulkResponse> checkForBulkOperationFailure(BulkResponse bulkResponse) {
        if (bulkResponse.hasFailures()) {
            HashMap<String, String> failedDocuments = new HashMap<String, String>();
            for (BulkItemResponse item : bulkResponse.getItems()) {
                if (!item.isFailed()) continue;
                failedDocuments.put(item.getId(), item.getFailureMessage());
            }
            BulkFailureException exception = new BulkFailureException("Bulk operation has failures. Use ElasticsearchException.getFailedDocuments() for detailed messages [" + failedDocuments + ']', failedDocuments);
            return Mono.error((Throwable)((Object)exception));
        }
        return Mono.just((Object)bulkResponse);
    }

    @Override
    public Mono<Boolean> exists(String id, Class<?> entityType) {
        return this.doExists(id, this.getIndexCoordinatesFor(entityType));
    }

    @Override
    public Mono<Boolean> exists(String id, IndexCoordinates index) {
        return this.doExists(id, index);
    }

    @Override
    public Mono<Boolean> exists(String id, Class<?> entityType, IndexCoordinates index) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        return this.doExists(id, index);
    }

    private Mono<Boolean> doExists(String id, IndexCoordinates index) {
        return Mono.defer(() -> this.doExists(this.requestFactory.getRequest(id, index)));
    }

    protected Mono<Boolean> doExists(GetRequest request) {
        return Mono.from(this.execute(client -> client.exists(request))).onErrorReturn(NoSuchIndexException.class, (Object)false);
    }

    private <T> Mono<Tuple2<T, IndexResponse>> doIndex(T entity, IndexCoordinates index) {
        IndexRequest request = this.requestFactory.indexRequest(this.getIndexQuery(entity), index);
        request = this.prepareIndexRequest(entity, request);
        return Mono.just(entity).zipWith(this.doIndex(request));
    }

    private IndexQuery getIndexQuery(Object value) {
        Number version;
        SeqNoPrimaryTerm seqNoPrimaryTerm;
        EntityOperations.AdaptibleEntity<Object> entity = this.operations.forEntity(value, this.converter.getConversionService());
        Object id = entity.getId();
        IndexQuery query = new IndexQuery();
        if (id != null) {
            query.setId(id.toString());
        }
        query.setObject(value);
        boolean usingSeqNo = false;
        if (entity.hasSeqNoPrimaryTerm() && (seqNoPrimaryTerm = entity.getSeqNoPrimaryTerm()) != null) {
            query.setSeqNo(seqNoPrimaryTerm.getSequenceNumber());
            query.setPrimaryTerm(seqNoPrimaryTerm.getPrimaryTerm());
            usingSeqNo = true;
        }
        if (!usingSeqNo && entity.isVersionedEntity() && (version = entity.getVersion()) != null) {
            query.setVersion(version.longValue());
        }
        return query;
    }

    @Override
    public <T> Mono<T> get(String id, Class<T> entityType) {
        return this.get(id, entityType, this.getIndexCoordinatesFor(entityType));
    }

    @Override
    public <T> Mono<T> get(String id, Class<T> entityType, IndexCoordinates index) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        ReadDocumentCallback callback = new ReadDocumentCallback(this.converter, entityType, index);
        return this.doGet(id, this.getPersistentEntityFor(entityType), index).flatMap(it -> callback.doWith(DocumentAdapters.from(it)));
    }

    private Mono<GetResult> doGet(String id, ElasticsearchPersistentEntity<?> entity, IndexCoordinates index) {
        return Mono.defer(() -> this.doGet(this.requestFactory.getRequest(id, index)));
    }

    protected Mono<GetResult> doGet(GetRequest request) {
        return Mono.from(this.execute(client -> client.get(request))).onErrorResume(NoSuchIndexException.class, it -> Mono.empty());
    }

    @Override
    public Mono<String> delete(Object entity, IndexCoordinates index) {
        EntityOperations.Entity<Object> elasticsearchEntity = this.operations.forEntity(entity);
        return Mono.defer(() -> this.doDeleteById(this.converter.convertId(elasticsearchEntity.getId()), index));
    }

    @Override
    public Mono<String> delete(Object entity) {
        return this.delete(entity, this.getIndexCoordinatesFor(entity.getClass()));
    }

    @Override
    public Mono<String> delete(String id, Class<?> entityType) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull(entityType, (String)"entityType must not be null");
        return this.delete(id, this.getIndexCoordinatesFor(entityType));
    }

    @Override
    public Mono<String> delete(String id, IndexCoordinates index) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        return this.doDeleteById(id, index);
    }

    private Mono<String> doDeleteById(String id, IndexCoordinates index) {
        return Mono.defer(() -> {
            DeleteRequest request = this.requestFactory.deleteRequest(id, index);
            return this.doDelete(this.prepareDeleteRequest(request));
        });
    }

    @Override
    public Mono<Long> delete(Query query, Class<?> entityType, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        return this.doDeleteBy(query, entityType, index).map(BulkByScrollResponse::getDeleted).publishNext();
    }

    @Override
    public Mono<Long> delete(Query query, Class<?> entityType) {
        return this.delete(query, entityType, this.getIndexCoordinatesFor(entityType));
    }

    private Flux<BulkByScrollResponse> doDeleteBy(Query query, Class<?> entityType, IndexCoordinates index) {
        return Flux.defer(() -> {
            DeleteByQueryRequest request = this.requestFactory.deleteByQueryRequest(query, entityType, index);
            return this.doDeleteBy(this.prepareDeleteByRequest(request));
        });
    }

    protected Mono<String> doDelete(DeleteRequest request) {
        return Mono.from(this.execute(client -> client.delete(request))).flatMap(it -> {
            if (HttpStatus.valueOf((int)it.status().getStatus()).equals((Object)HttpStatus.NOT_FOUND)) {
                return Mono.empty();
            }
            return Mono.just((Object)it.getId());
        }).onErrorResume(NoSuchIndexException.class, it -> Mono.empty());
    }

    protected Mono<BulkByScrollResponse> doDeleteBy(DeleteByQueryRequest request) {
        return Mono.from(this.execute(client -> client.deleteBy(request))).onErrorResume(NoSuchIndexException.class, it -> Mono.empty());
    }

    protected DeleteRequest prepareDeleteRequest(DeleteRequest request) {
        return this.prepareWriteRequest(request);
    }

    protected DeleteByQueryRequest prepareDeleteByRequest(DeleteByQueryRequest request) {
        if (this.refreshPolicy != null) {
            request = WriteRequest.RefreshPolicy.NONE.equals((Object)this.refreshPolicy) ? (DeleteByQueryRequest)request.setRefresh(false) : (DeleteByQueryRequest)request.setRefresh(true);
        }
        if (this.indicesOptions != null) {
            request = request.setIndicesOptions(this.indicesOptions);
        }
        return request;
    }

    protected IndexRequest prepareIndexRequest(Object source, IndexRequest request) {
        return this.prepareWriteRequest(request);
    }

    protected <R extends WriteRequest<R>> R prepareWriteRequest(R request) {
        if (this.refreshPolicy == null) {
            return request;
        }
        return (R)request.setRefreshPolicy(this.refreshPolicy);
    }

    @Override
    public <T> Flux<SearchHit<T>> search(Query query, Class<?> entityType, Class<T> resultType, IndexCoordinates index) {
        ReadSearchDocumentCallback<T> callback = new ReadSearchDocumentCallback<T>(resultType, index);
        return this.doFind(query, entityType, index).concatMap(callback::doWith);
    }

    @Override
    public <T> Flux<SearchHit<T>> search(Query query, Class<?> entityType, Class<T> returnType) {
        return this.search(query, entityType, returnType, this.getIndexCoordinatesFor(entityType));
    }

    private Flux<SearchDocument> doFind(Query query, Class<?> clazz, IndexCoordinates index) {
        if (query instanceof CriteriaQuery) {
            this.converter.updateQuery((CriteriaQuery)query, clazz);
        }
        return Flux.defer(() -> {
            SearchRequest request = this.requestFactory.searchRequest(query, clazz, index);
            request = this.prepareSearchRequest(request);
            if (query.getPageable().isPaged() || query.isLimiting()) {
                return this.doFind(request);
            }
            return this.doScroll(request);
        });
    }

    @Override
    public Flux<Aggregation> aggregate(Query query, Class<?> entityType) {
        return this.aggregate(query, entityType, this.getIndexCoordinatesFor(entityType));
    }

    @Override
    public Flux<Aggregation> aggregate(Query query, Class<?> entityType, IndexCoordinates index) {
        return this.doAggregate(query, entityType, index);
    }

    private Flux<Aggregation> doAggregate(Query query, Class<?> entityType, IndexCoordinates index) {
        return Flux.defer(() -> {
            SearchRequest request = this.requestFactory.searchRequest(query, entityType, index);
            request = this.prepareSearchRequest(request);
            return this.doAggregate(request);
        });
    }

    @Override
    public Mono<Long> count(Query query, Class<?> entityType) {
        return this.count(query, entityType, this.getIndexCoordinatesFor(entityType));
    }

    @Override
    public Mono<Long> count(Query query, Class<?> entityType, IndexCoordinates index) {
        return this.doCount(query, entityType, index);
    }

    private Mono<Long> doCount(Query query, Class<?> entityType, IndexCoordinates index) {
        return Mono.defer(() -> {
            SearchRequest request = this.requestFactory.searchRequest(query, entityType, index);
            request = this.prepareSearchRequest(request);
            return this.doCount(request);
        });
    }

    protected Flux<SearchDocument> doFind(SearchRequest request) {
        if (QUERY_LOGGER.isDebugEnabled()) {
            QUERY_LOGGER.debug("Executing doFind: {}", (Object)request);
        }
        return Flux.from(this.execute(client -> client.search(request))).map(DocumentAdapters::from).onErrorResume(NoSuchIndexException.class, it -> Mono.empty());
    }

    protected Flux<Aggregation> doAggregate(SearchRequest request) {
        if (QUERY_LOGGER.isDebugEnabled()) {
            QUERY_LOGGER.debug("Executing doCount: {}", (Object)request);
        }
        return Flux.from(this.execute(client -> client.aggregate(request))).onErrorResume(NoSuchIndexException.class, it -> Flux.empty());
    }

    protected Mono<Long> doCount(SearchRequest request) {
        if (QUERY_LOGGER.isDebugEnabled()) {
            QUERY_LOGGER.debug("Executing doCount: {}", (Object)request);
        }
        return Mono.from(this.execute(client -> client.count(request))).onErrorResume(NoSuchIndexException.class, it -> Mono.just((Object)0L));
    }

    protected Flux<SearchDocument> doScroll(SearchRequest request) {
        if (QUERY_LOGGER.isDebugEnabled()) {
            QUERY_LOGGER.debug("Executing doScroll: {}", (Object)request);
        }
        return Flux.from(this.execute(client -> client.scroll(request))).map(DocumentAdapters::from).onErrorResume(NoSuchIndexException.class, it -> Mono.empty());
    }

    protected SearchRequest prepareSearchRequest(SearchRequest request) {
        if (this.indicesOptions == null) {
            return request;
        }
        return request.indicesOptions(this.indicesOptions);
    }

    protected Mono<String> getClusterVersion() {
        try {
            return Mono.from(this.execute(client -> client.info())).map(mainResponse -> mainResponse.getVersion().toString());
        }
        catch (Exception exception) {
            return Mono.empty();
        }
    }

    public void setRefreshPolicy(@Nullable WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
    }

    public void setIndicesOptions(@Nullable IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
    }

    @Override
    public <T> Publisher<T> execute(ReactiveElasticsearchOperations.ClientCallback<Publisher<T>> callback) {
        return Flux.defer(() -> callback.doWithClient(this.getClient())).onErrorMap(this::translateException);
    }

    @Override
    public ElasticsearchConverter getElasticsearchConverter() {
        return this.converter;
    }

    @Override
    public IndexCoordinates getIndexCoordinatesFor(Class<?> clazz) {
        return this.getPersistentEntityFor(clazz).getIndexCoordinates();
    }

    @Override
    @Nullable
    public ElasticsearchPersistentEntity<?> getPersistentEntityFor(@Nullable Class<?> type) {
        return type != null ? (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(type) : null;
    }

    protected ReactiveElasticsearchClient getClient() {
        return this.client;
    }

    private RuntimeException translateException(Throwable throwable) {
        RuntimeException runtimeException = throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable.getMessage(), throwable);
        DataAccessException potentiallyTranslatedException = this.exceptionTranslator.translateExceptionIfPossible(runtimeException);
        return potentiallyTranslatedException != null ? potentiallyTranslatedException : runtimeException;
    }

    protected <T> Mono<T> maybeCallBeforeConvert(T entity, IndexCoordinates index) {
        if (null != this.entityCallbacks) {
            return this.entityCallbacks.callback(ReactiveBeforeConvertCallback.class, entity, new Object[]{index});
        }
        return Mono.just(entity);
    }

    protected <T> Mono<T> maybeCallAfterSave(T entity, IndexCoordinates index) {
        if (null != this.entityCallbacks) {
            return this.entityCallbacks.callback(ReactiveAfterSaveCallback.class, entity, new Object[]{index});
        }
        return Mono.just(entity);
    }

    protected <T> Mono<T> maybeCallAfterConvert(T entity, Document document, IndexCoordinates index) {
        if (null != this.entityCallbacks) {
            return this.entityCallbacks.callback(ReactiveAfterConvertCallback.class, entity, new Object[]{document, index});
        }
        return Mono.just(entity);
    }

    private class Entities<T> {
        private final List<T> entities;

        private Entities(List<T> entities) {
            Assert.notNull(entities, (String)"entities cannot be null");
            this.entities = entities;
        }

        private boolean isEmpty() {
            return this.entities.isEmpty();
        }

        private List<IndexQuery> indexQueries() {
            return this.entities.stream().map(x$0 -> ReactiveElasticsearchTemplate.this.getIndexQuery(x$0)).collect(Collectors.toList());
        }

        private T entityAt(long index) {
            int intIndex = (int)index;
            return this.entities.get(intIndex);
        }
    }

    protected class ReadSearchDocumentCallback<T>
    implements SearchDocumentCallback<T> {
        private final DocumentCallback<T> delegate;
        private final Class<T> type;

        public ReadSearchDocumentCallback(Class<T> type, IndexCoordinates index) {
            Assert.notNull(type, (String)"type is null");
            this.delegate = new ReadDocumentCallback<T>(ReactiveElasticsearchTemplate.this.converter, type, index);
            this.type = type;
        }

        @Override
        public Mono<SearchHit<T>> doWith(SearchDocument response) {
            return this.delegate.doWith(response).map(entity -> SearchHitMapping.mappingFor(this.type, ReactiveElasticsearchTemplate.this.converter.getMappingContext()).mapHit(response, entity));
        }
    }

    protected static interface SearchDocumentCallback<T> {
        @NonNull
        public Mono<SearchHit<T>> doWith(@NonNull SearchDocument var1);
    }

    protected class ReadDocumentCallback<T>
    implements DocumentCallback<T> {
        private final EntityReader<? super T, Document> reader;
        private final Class<T> type;
        private final IndexCoordinates index;

        public ReadDocumentCallback(EntityReader<? super T, Document> reader, Class<T> type, IndexCoordinates index) {
            Assert.notNull(reader, (String)"reader is null");
            Assert.notNull(type, (String)"type is null");
            this.reader = reader;
            this.type = type;
            this.index = index;
        }

        @Override
        @NonNull
        public Mono<T> doWith(@Nullable Document document) {
            if (document == null) {
                return Mono.empty();
            }
            Object entity = this.reader.read(this.type, (Object)document);
            return ReactiveElasticsearchTemplate.this.maybeCallAfterConvert(entity, document, this.index);
        }
    }

    protected static interface DocumentCallback<T> {
        @NonNull
        public Mono<T> doWith(@Nullable Document var1);
    }
}

