/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.function.client.WebClientException;

public class WebClientResponseException
extends WebClientException {
    private static final long serialVersionUID = 4127543205414951611L;
    private final int statusCode;
    private final String statusText;
    private final byte[] responseBody;
    private final HttpHeaders headers;
    private final Charset responseCharset;
    @Nullable
    private final HttpRequest request;

    public WebClientResponseException(int statusCode, String statusText, @Nullable HttpHeaders headers2, @Nullable byte[] body2, @Nullable Charset charset) {
        this(statusCode, statusText, headers2, body2, charset, null);
    }

    public WebClientResponseException(int statusCode, String statusText, @Nullable HttpHeaders headers2, @Nullable byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
        this(statusCode + " " + statusText, statusCode, statusText, headers2, body2, charset, request);
    }

    public WebClientResponseException(String message, int statusCode, String statusText, @Nullable HttpHeaders headers2, @Nullable byte[] responseBody, @Nullable Charset charset) {
        this(message, statusCode, statusText, headers2, responseBody, charset, null);
    }

    public WebClientResponseException(String message, int statusCode, String statusText, @Nullable HttpHeaders headers2, @Nullable byte[] responseBody, @Nullable Charset charset, @Nullable HttpRequest request) {
        super(message);
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.headers = headers2 != null ? headers2 : HttpHeaders.EMPTY;
        this.responseBody = responseBody != null ? responseBody : new byte[]{};
        this.responseCharset = charset != null ? charset : StandardCharsets.ISO_8859_1;
        this.request = request;
    }

    public HttpStatus getStatusCode() {
        return HttpStatus.valueOf((int)this.statusCode);
    }

    public int getRawStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public byte[] getResponseBodyAsByteArray() {
        return this.responseBody;
    }

    public String getResponseBodyAsString() {
        return new String(this.responseBody, this.responseCharset);
    }

    @Nullable
    public HttpRequest getRequest() {
        return this.request;
    }

    public static WebClientResponseException create(int statusCode, String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset) {
        return WebClientResponseException.create(statusCode, statusText, headers2, body2, charset, null);
    }

    public static WebClientResponseException create(int statusCode, String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
        HttpStatus httpStatus = HttpStatus.resolve((int)statusCode);
        if (httpStatus != null) {
            switch (httpStatus) {
                case BAD_REQUEST: {
                    return new BadRequest(statusText, headers2, body2, charset, request);
                }
                case UNAUTHORIZED: {
                    return new Unauthorized(statusText, headers2, body2, charset, request);
                }
                case FORBIDDEN: {
                    return new Forbidden(statusText, headers2, body2, charset, request);
                }
                case NOT_FOUND: {
                    return new NotFound(statusText, headers2, body2, charset, request);
                }
                case METHOD_NOT_ALLOWED: {
                    return new MethodNotAllowed(statusText, headers2, body2, charset, request);
                }
                case NOT_ACCEPTABLE: {
                    return new NotAcceptable(statusText, headers2, body2, charset, request);
                }
                case CONFLICT: {
                    return new Conflict(statusText, headers2, body2, charset, request);
                }
                case GONE: {
                    return new Gone(statusText, headers2, body2, charset, request);
                }
                case UNSUPPORTED_MEDIA_TYPE: {
                    return new UnsupportedMediaType(statusText, headers2, body2, charset, request);
                }
                case TOO_MANY_REQUESTS: {
                    return new TooManyRequests(statusText, headers2, body2, charset, request);
                }
                case UNPROCESSABLE_ENTITY: {
                    return new UnprocessableEntity(statusText, headers2, body2, charset, request);
                }
                case INTERNAL_SERVER_ERROR: {
                    return new InternalServerError(statusText, headers2, body2, charset, request);
                }
                case NOT_IMPLEMENTED: {
                    return new NotImplemented(statusText, headers2, body2, charset, request);
                }
                case BAD_GATEWAY: {
                    return new BadGateway(statusText, headers2, body2, charset, request);
                }
                case SERVICE_UNAVAILABLE: {
                    return new ServiceUnavailable(statusText, headers2, body2, charset, request);
                }
                case GATEWAY_TIMEOUT: {
                    return new GatewayTimeout(statusText, headers2, body2, charset, request);
                }
            }
        }
        return new WebClientResponseException(statusCode, statusText, headers2, body2, charset, request);
    }

    public static class GatewayTimeout
    extends WebClientResponseException {
        GatewayTimeout(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.GATEWAY_TIMEOUT.value(), statusText, headers2, body2, charset, request);
        }
    }

    public static class ServiceUnavailable
    extends WebClientResponseException {
        ServiceUnavailable(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.SERVICE_UNAVAILABLE.value(), statusText, headers2, body2, charset, request);
        }
    }

    public static class BadGateway
    extends WebClientResponseException {
        BadGateway(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.BAD_GATEWAY.value(), statusText, headers2, body2, charset, request);
        }
    }

    public static class NotImplemented
    extends WebClientResponseException {
        NotImplemented(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.NOT_IMPLEMENTED.value(), statusText, headers2, body2, charset, request);
        }
    }

    public static class InternalServerError
    extends WebClientResponseException {
        InternalServerError(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.INTERNAL_SERVER_ERROR.value(), statusText, headers2, body2, charset, request);
        }
    }

    public static class TooManyRequests
    extends WebClientResponseException {
        TooManyRequests(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.TOO_MANY_REQUESTS.value(), statusText, headers2, body2, charset, request);
        }
    }

    public static class UnprocessableEntity
    extends WebClientResponseException {
        UnprocessableEntity(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.UNPROCESSABLE_ENTITY.value(), statusText, headers2, body2, charset, request);
        }
    }

    public static class UnsupportedMediaType
    extends WebClientResponseException {
        UnsupportedMediaType(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.UNSUPPORTED_MEDIA_TYPE.value(), statusText, headers2, body2, charset, request);
        }
    }

    public static class Gone
    extends WebClientResponseException {
        Gone(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.GONE.value(), statusText, headers2, body2, charset, request);
        }
    }

    public static class Conflict
    extends WebClientResponseException {
        Conflict(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.CONFLICT.value(), statusText, headers2, body2, charset, request);
        }
    }

    public static class NotAcceptable
    extends WebClientResponseException {
        NotAcceptable(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.NOT_ACCEPTABLE.value(), statusText, headers2, body2, charset, request);
        }
    }

    public static class MethodNotAllowed
    extends WebClientResponseException {
        MethodNotAllowed(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.METHOD_NOT_ALLOWED.value(), statusText, headers2, body2, charset, request);
        }
    }

    public static class NotFound
    extends WebClientResponseException {
        NotFound(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.NOT_FOUND.value(), statusText, headers2, body2, charset, request);
        }
    }

    public static class Forbidden
    extends WebClientResponseException {
        Forbidden(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.FORBIDDEN.value(), statusText, headers2, body2, charset, request);
        }
    }

    public static class Unauthorized
    extends WebClientResponseException {
        Unauthorized(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.UNAUTHORIZED.value(), statusText, headers2, body2, charset, request);
        }
    }

    public static class BadRequest
    extends WebClientResponseException {
        BadRequest(String statusText, HttpHeaders headers2, byte[] body2, @Nullable Charset charset, @Nullable HttpRequest request) {
            super(HttpStatus.BAD_REQUEST.value(), statusText, headers2, body2, charset, request);
        }
    }
}

