/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.edge.northbound.device.spitesam.util;

import com.easesource.edge.core.common.util.convert.JsonConvertUtils;
import com.easesource.edge.periphery.Spitesam;
import com.easesource.edge.southbound.model.tesam.base.TesamMethodEnum;
import com.easesource.edge.southbound.model.tesam.base.TesamRxResponse;
import com.easesource.edge.southbound.model.tesam.base.TesamTxRequest;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpitesamOperationUtils {
    private static final Logger logger = LoggerFactory.getLogger(SpitesamOperationUtils.class);
    private static final String DEFAULT_DEVICES = "/dev/spidev2.0";
    private static final int DEFAULT_MODE = 3;
    private static final int DEFAULT_SPEED = 25000;

    public static byte[] transmit(String device, byte[] txBuf, int rxLength) {
        device = device == null ? DEFAULT_DEVICES : device;
        return SpitesamOperationUtils.transmit(device, 3, 25000, txBuf, rxLength);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] transmit(String device, int mode, int speed, byte[] txBuf, int rxLength) {
        String str = Hex.encodeHexString((byte[])txBuf);
        try (Spitesam spitesam = new Spitesam(device, mode, speed);){
            if (txBuf != null && txBuf.length > 0) {
                logger.info("tx data    : " + Hex.encodeHexString((byte[])txBuf));
                byte[] rxBuf = new byte[rxLength];
                Spitesam.spitesamTransfer((long)spitesam.getHandle(), (byte[])txBuf, (byte[])rxBuf, (long)txBuf.length);
                logger.info("rx data    : " + Hex.encodeHexString((byte[])rxBuf));
                byte[] byArray = rxBuf;
                return byArray;
            }
            logger.error("txBuf is empty.");
            return null;
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), e.fillInStackTrace());
        }
        return null;
    }

    public static byte calcXorAndNot(byte[] datas) {
        int lrc = 0;
        for (byte b : datas) {
            lrc = (byte)(lrc ^ b);
        }
        return (byte)(~lrc);
    }

    public static String getRxDataFollowLrc(String rxDataWithoutLrc) {
        try {
            byte[] datas = Hex.decodeHex((String)rxDataWithoutLrc);
            byte lrc = SpitesamOperationUtils.calcXorAndNot(datas);
            byte[] lrcs = new byte[]{lrc};
            byte[] newBytes = new byte[datas.length + 1];
            System.arraycopy(datas, 0, newBytes, 0, datas.length);
            System.arraycopy(lrcs, 0, newBytes, datas.length, lrcs.length);
            return Hex.encodeHexString((byte[])newBytes, (boolean)false);
        }
        catch (DecoderException e) {
            logger.error(e.getMessage(), e.fillInStackTrace());
            return rxDataWithoutLrc;
        }
    }

    public static TesamRxResponse request(TesamTxRequest tesamTxRequest) {
        return SpitesamOperationUtils.request(tesamTxRequest, null);
    }

    public static TesamRxResponse request(TesamTxRequest tesamTxRequest, String device) {
        String mac;
        String sidIndi;
        String dataStart;
        StringBuilder sbData;
        if (logger.isInfoEnabled()) {
            logger.info(" TesamTxRequest    : " + JsonConvertUtils.convertToString((Object)tesamTxRequest));
        }
        TesamRxResponse tesamRxResponse = new TesamRxResponse();
        if (tesamTxRequest == null) {
            logger.error(" TesamTxRequest is null. ");
            return null;
        }
        String id = tesamTxRequest.getId();
        String method = tesamTxRequest.getMethod();
        String type = tesamTxRequest.getType();
        LinkedHashMap params = tesamTxRequest.getParams();
        LinkedHashMap datas = tesamTxRequest.getDatas();
        tesamRxResponse.setId(id);
        tesamRxResponse.setMethod(method);
        String payload = "55803600FF0000B6";
        int length = 128;
        int resDataLength = 0;
        int[] resDataLenDivided = new int[]{};
        LinkedHashMap resDataMap = Maps.newLinkedHashMap();
        if (StringUtils.equals((CharSequence)method, (CharSequence)TesamMethodEnum.GET_UC_SIGN.getCode())) {
            sbData = new StringBuilder();
            dataStart = "80020000";
            sbData.append(dataStart);
            int lc = 0;
            String p2 = "";
            String s2 = "";
            if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("p2"))) && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("s2")))) {
                p2 = (String)datas.get("p2");
                s2 = (String)datas.get("s2");
            } else if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("d1"))) && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("d2")))) {
                p2 = (String)datas.get("d1");
                s2 = (String)datas.get("d2");
            }
            try {
                lc = Hex.decodeHex((String)p2).length + Hex.decodeHex((String)s2).length;
            }
            catch (DecoderException e) {
                logger.error(e.getMessage(), e.fillInStackTrace());
            }
            sbData.append(StringUtils.leftPad((String)Integer.toHexString(lc), (int)4, (char)'0'));
            sbData.append(p2);
            sbData.append(s2);
            payload = "55" + SpitesamOperationUtils.getRxDataFollowLrc(sbData.toString());
            length = 128;
            resDataLength = 112;
            resDataLenDivided = new int[]{48, 64};
        } else if (StringUtils.equals((CharSequence)method, (CharSequence)TesamMethodEnum.HANDLE_SECTITY_DATA_DOWN.getCode())) {
            sbData = new StringBuilder();
            if (StringUtils.equals((CharSequence)type, (CharSequence)"step4")) {
                if (params != null && StringUtils.isNotBlank((CharSequence)((CharSequence)params.get("sid.indi"))) && StringUtils.isNotBlank((CharSequence)((CharSequence)params.get("sid.fdata")))) {
                    sidIndi = (String)params.get("sid.indi");
                    String sidFdata = (String)params.get("sid.fdata");
                    String data = "";
                    mac = "";
                    if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("data")))) {
                        data = (String)datas.get("data");
                    } else if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("d1")))) {
                        data = (String)datas.get("d1");
                    }
                    if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("mac")))) {
                        mac = (String)datas.get("mac");
                    } else if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("d2")))) {
                        mac = (String)datas.get("d2");
                    }
                    sbData.append(sidIndi);
                    sbData.append(sidFdata);
                    sbData.append(data);
                    sbData.append(mac);
                    payload = "55" + SpitesamOperationUtils.getRxDataFollowLrc(sbData.toString());
                    length = 4096;
                }
            } else if (StringUtils.equals((CharSequence)type, (CharSequence)"step7")) {
                String p2 = "11";
                if (params != null && StringUtils.isNotBlank((CharSequence)((CharSequence)params.get("p2")))) {
                    switch ((String)params.get("p2")) {
                        case "11": {
                            p2 = "11";
                            break;
                        }
                        case "96": {
                            p2 = "96";
                            break;
                        }
                        case "97": {
                            p2 = "97";
                            break;
                        }
                    }
                }
                String dataStart2 = "801C00" + p2;
                sbData.append(dataStart2);
                int lc = 0;
                String data = "";
                if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("data")))) {
                    data = (String)datas.get("data");
                } else if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("d1")))) {
                    data = (String)datas.get("d1");
                }
                if (StringUtils.isNotBlank((CharSequence)data)) {
                    try {
                        lc = Hex.decodeHex((String)data).length;
                    }
                    catch (DecoderException e) {
                        logger.error(e.getMessage(), e.fillInStackTrace());
                    }
                }
                sbData.append(StringUtils.leftPad((String)Integer.toHexString(lc), (int)4, (char)'0'));
                sbData.append(data);
                payload = "55" + SpitesamOperationUtils.getRxDataFollowLrc(sbData.toString());
                length = 4096;
            }
        } else if (StringUtils.equals((CharSequence)method, (CharSequence)TesamMethodEnum.HANDLE_SECTITY_DATA_UP.getCode())) {
            sbData = new StringBuilder();
            if (StringUtils.equals((CharSequence)type, (CharSequence)"step1")) {
                dataStart = "80140103";
                sbData.append(dataStart);
                int lc = 0;
                String plain = "";
                if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("plain")))) {
                    plain = (String)datas.get("plain");
                } else if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("d1")))) {
                    plain = (String)datas.get("d1");
                }
                try {
                    lc = Hex.decodeHex((String)plain).length;
                }
                catch (DecoderException e) {
                    logger.error(e.getMessage(), e.fillInStackTrace());
                }
                sbData.append(StringUtils.leftPad((String)Integer.toHexString(lc), (int)4, (char)'0'));
                sbData.append(plain);
                payload = "55" + SpitesamOperationUtils.getRxDataFollowLrc(sbData.toString());
                length = 64;
                resDataLength = 16;
                resDataLenDivided = new int[]{12, 4};
            } else if (StringUtils.equals((CharSequence)type, (CharSequence)"step4") && params != null && StringUtils.isNotBlank((CharSequence)((CharSequence)params.get("sid.indi"))) && StringUtils.isNotBlank((CharSequence)((CharSequence)params.get("sid.fdata")))) {
                sidIndi = (String)params.get("sid.indi");
                String sidFdata = (String)params.get("sid.fdata");
                String data = "";
                mac = "";
                if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("data")))) {
                    data = (String)datas.get("data");
                } else if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("d1")))) {
                    data = (String)datas.get("d1");
                }
                if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("mac")))) {
                    mac = (String)datas.get("mac");
                } else if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("d2")))) {
                    mac = (String)datas.get("d2");
                }
                sbData.append(sidIndi);
                sbData.append(sidFdata);
                sbData.append(data);
                sbData.append(mac);
                payload = "55" + SpitesamOperationUtils.getRxDataFollowLrc(sbData.toString());
                length = 4096;
            }
        } else if (StringUtils.equals((CharSequence)method, (CharSequence)TesamMethodEnum.HANDLE_APP_LAYER_PROTO.getCode())) {
            sbData = new StringBuilder();
            if (StringUtils.equals((CharSequence)type, (CharSequence)"action")) {
                if (params != null && StringUtils.isNotBlank((CharSequence)((CharSequence)params.get("sid.indi"))) && StringUtils.isNotBlank((CharSequence)((CharSequence)params.get("sid.fdata")))) {
                    sidIndi = (String)params.get("sid.indi");
                    String sidFdata = (String)params.get("sid.fdata");
                    String data = "";
                    mac = "";
                    if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("data")))) {
                        data = (String)datas.get("data");
                    } else if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("d1")))) {
                        data = (String)datas.get("d1");
                    }
                    if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("mac")))) {
                        mac = (String)datas.get("mac");
                    } else if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("d2")))) {
                        mac = (String)datas.get("d2");
                    }
                    sbData.append(sidIndi);
                    sbData.append(sidFdata);
                    sbData.append(data);
                    sbData.append(mac);
                    payload = "55" + SpitesamOperationUtils.getRxDataFollowLrc(sbData.toString());
                    length = 64;
                }
            } else {
                dataStart = "800E4002";
                sbData.append(dataStart);
                int lc = 0;
                String rn = "";
                String plain = "";
                if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("rn")))) {
                    rn = (String)datas.get("rn");
                } else if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("d1")))) {
                    rn = (String)datas.get("d1");
                }
                if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("plain")))) {
                    plain = (String)datas.get("plain");
                } else if (datas != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get("d2")))) {
                    plain = (String)datas.get("d2");
                }
                try {
                    lc = Hex.decodeHex((String)rn).length + Hex.decodeHex((String)plain).length;
                }
                catch (DecoderException e) {
                    logger.error(e.getMessage(), e.fillInStackTrace());
                }
                sbData.append(StringUtils.leftPad((String)Integer.toHexString(lc), (int)4, (char)'0'));
                sbData.append(rn);
                sbData.append(plain);
                payload = "55" + SpitesamOperationUtils.getRxDataFollowLrc(sbData.toString());
                length = 64;
                resDataLength = 4;
                resDataLenDivided = new int[]{4};
            }
        }
        try {
            byte[] rxBuf = SpitesamOperationUtils.transmit(device, Hex.decodeHex((String)payload), length);
            if (rxBuf != null && rxBuf.length >= 5 && rxBuf[0] == 85) {
                byte sw1 = rxBuf[1];
                byte sw2 = rxBuf[2];
                logger.info(" sw1 : " + Hex.encodeHexString((byte[])new byte[]{sw1}) + ", sw2 : " + Hex.encodeHexString((byte[])new byte[]{sw2}));
                String sw = Hex.encodeHexString((byte[])new byte[]{sw1, sw2});
                byte len1 = rxBuf[3];
                byte len2 = rxBuf[4];
                int len = Integer.parseInt(Hex.encodeHexString((byte[])new byte[]{len1, len2}), 16);
                logger.info(" sw    : " + sw + ", len   : " + len);
                if (StringUtils.equals((CharSequence)sw, (CharSequence)"9000")) {
                    if (len > 0 && rxBuf.length > 5 + len) {
                        byte[] dataBytes = new byte[len];
                        System.arraycopy(rxBuf, 5, dataBytes, 0, len);
                        logger.info(" data  : " + Hex.encodeHexString((byte[])dataBytes));
                        logger.info(" lrc   : " + Hex.encodeHexString((byte[])new byte[]{rxBuf[5 + len]}));
                        if (resDataLenDivided.length > 0 && len >= resDataLength) {
                            int index = 0;
                            for (int i = 0; i < resDataLenDivided.length; ++i) {
                                byte[] dataBytesTemp = new byte[resDataLenDivided[i]];
                                System.arraycopy(dataBytes, index, dataBytesTemp, 0, dataBytesTemp.length);
                                index += dataBytesTemp.length;
                                resDataMap.put("d" + String.valueOf(i + 1), Hex.encodeHexString((byte[])dataBytesTemp));
                            }
                        } else {
                            resDataMap.put("d1", Hex.encodeHexString((byte[])dataBytes));
                        }
                        tesamRxResponse.setSw(sw);
                        tesamRxResponse.setLen(len);
                        tesamRxResponse.setDataBytes(dataBytes);
                        tesamRxResponse.setLrc(rxBuf[5 + len]);
                        tesamRxResponse.setDatas(resDataMap);
                    } else {
                        tesamRxResponse.setSw(sw);
                        tesamRxResponse.setLen(len);
                    }
                } else {
                    tesamRxResponse.setSw((String)StringUtils.defaultIfBlank((CharSequence)sw, (CharSequence)"0000"));
                    tesamRxResponse.setLen(len);
                }
            }
        }
        catch (NumberFormatException | DecoderException e) {
            logger.error(e.getMessage(), e.fillInStackTrace());
        }
        if (logger.isInfoEnabled()) {
            logger.info(" TesamRxResponse   : " + JsonConvertUtils.convertToString((Object)tesamRxResponse));
        }
        return tesamRxResponse;
    }
}

