package com.easesource.edge.northbound.service.gpio;

import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SouthboundMqttGpioCallback implements MqttCallbackExtended {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public void connectComplete(boolean reconnect, String serverUri) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> [southbound mqtt gpio callback] start connectComplete >>>>>> ");
            logger.debug(" reconnect  : " + reconnect);
            logger.debug(" serverUri  : " + serverUri);
            logger.debug(" <<<<<<< [southbound mqtt gpio callback] end connectComplete <<<<<<< ");
        }
    }

    @Override
    public void connectionLost(Throwable throwable) {
        logger.warn(" >>>>>> [southbound mqtt gpio callback] start connectionLost >>>>>> ");
        logger.error(" Connection lost with cause \"" + throwable.getMessage() + "\", Reason code : " + ((MqttException) throwable).getReasonCode() + "\" Cause : \"" + throwable.getCause() +  "\"");
        logger.error(" error ", throwable);
        logger.warn(" <<<<<<< [southbound mqtt gpio callback] end connectionLost <<<<<<< ");
    }

    @Override
    public void messageArrived(String topic, MqttMessage mqttMessage) throws Exception {
        // subscribe后得到的消息会执行到这里面
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> [southbound mqtt gpio callback] start messageArrived >>>>>> ");
            logger.debug(" topic            : " + topic);
            if(mqttMessage != null && mqttMessage.getPayload() != null) {
                logger.debug(" messageId        : " + mqttMessage.getId());
                logger.debug(" messageContent   : " + new String(mqttMessage.getPayload()));
                logger.debug(" qos              : " + mqttMessage.getQos());
                logger.debug(" retained         : " + mqttMessage.isRetained());
                logger.debug(" duplicate        : " + mqttMessage.isDuplicate());
            }
            else {
                logger.debug(" mqttMessage is null ");
            }
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" <<<<<<< [southbound mqtt gpio callback] end messageArrived <<<<<<< ");
        }
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken token) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> [southbound mqtt gpio callback] start deliveryComplete >>>>>> ");
            logger.debug(" deliveryComplete : " + token.isComplete());
            logger.debug(" <<<<<<< [southbound mqtt gpio callback] end deliveryComplete <<<<<<< ");
        }
    }

}
