/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.edge.northbound.service.gpio;

import com.easesource.edge.core.common.util.convert.JsonConvertUtils;
import com.easesource.edge.core.mqbus.mqtt.MqttClientConfig;
import com.easesource.edge.core.mqbus.mqtt.MqttConnectConfig;
import com.easesource.edge.core.mqbus.mqtt.MqttReceiveHandler;
import com.easesource.edge.core.mqbus.mqtt.MqttSender;
import com.easesource.edge.core.mqbus.mqtt.MqttSubscribesConfig;
import com.easesource.edge.northbound.service.gpio.SouthboundMqttGpioCallback;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class MainApp {
    private static final Logger logger = LoggerFactory.getLogger(MainApp.class);

    public static void main(String ... args) {
        if (logger.isInfoEnabled()) {
            logger.info(" >>>>>>> start southbound service (gpio) >>>>>>> ");
        }
        Map appMaps = Maps.newLinkedHashMap();
        Yaml yaml = new Yaml();
        try {
            InputStream in = MainApp.class.getClassLoader().getResourceAsStream("application.yml");
            appMaps = (Map)yaml.load(in);
            logger.info(" appMaps : " + JsonConvertUtils.convertToString((Object)appMaps));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e.fillInStackTrace());
        }
        MqttClientConfig receiverClientConfig = new MqttClientConfig();
        MqttConnectConfig receiverConnectConfig = new MqttConnectConfig();
        MqttSubscribesConfig receiverSubscribesConfig = new MqttSubscribesConfig();
        MqttClientConfig senderClientConfig = new MqttClientConfig();
        MqttConnectConfig senderConnectConfig = new MqttConnectConfig();
        try {
            Map mqttProfileMap = (Map)appMaps.get("mqtt");
            receiverClientConfig.setServerUri((String)mqttProfileMap.get("server-uri"));
            receiverClientConfig.setClientId((String)((Map)mqttProfileMap.get("receiver")).get("client-id"));
            receiverConnectConfig.setUsername((String)mqttProfileMap.get("username"));
            receiverConnectConfig.setPassword((String)mqttProfileMap.get("password"));
            ArrayList receiverSubscribesTopics = (ArrayList)((Map)mqttProfileMap.get("receiver")).get("sub-topics");
            ArrayList receiverSubscribesQoss = (ArrayList)((Map)mqttProfileMap.get("receiver")).get("sub-qoss");
            if (receiverSubscribesTopics != null && receiverSubscribesQoss != null && receiverSubscribesTopics.size() == receiverSubscribesQoss.size()) {
                receiverSubscribesConfig.setTopics(receiverSubscribesTopics.toArray(new String[receiverSubscribesTopics.size()]));
                receiverSubscribesConfig.setQoss(receiverSubscribesQoss.stream().mapToInt(Integer::valueOf).toArray());
            }
            senderClientConfig.setServerUri((String)mqttProfileMap.get("server-uri"));
            senderClientConfig.setClientId((String)((Map)mqttProfileMap.get("sender")).get("client-id"));
            senderConnectConfig.setUsername((String)mqttProfileMap.get("username"));
            senderConnectConfig.setPassword((String)mqttProfileMap.get("password"));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e.fillInStackTrace());
            return;
        }
        MqttReceiveHandler southboundMqttReceiveHandler = null;
        try {
            southboundMqttReceiveHandler = new MqttReceiveHandler(receiverClientConfig, receiverConnectConfig, receiverSubscribesConfig, (MqttCallbackExtended)new SouthboundMqttGpioCallback());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e.fillInStackTrace());
        }
        if (southboundMqttReceiveHandler == null) {
            logger.error("southboundMqttLoopback is null.");
            return;
        }
        ListeningExecutorService servicePool = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        ListenableFuture future = servicePool.submit((Callable)southboundMqttReceiveHandler);
        future.addListener(() -> {
            try {
                logger.info(Thread.currentThread().getName() + " >> \u5f02\u6b65\u5904\u7406\u6210\u529f.... " + future.get());
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error(e.getMessage(), e.fillInStackTrace());
            }
        }, MoreExecutors.directExecutor());
        try {
            MqttSender southboundMqttSender = new MqttSender(senderClientConfig, senderConnectConfig);
            southboundMqttSender.sendToMqtt("hello", "/device/gpio/do1");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e.fillInStackTrace());
        }
        if (logger.isInfoEnabled()) {
            logger.info(" <<<<<<<< end southbound service (gpio) <<<<<<<< ");
        }
    }
}

