/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.edge.northbound.service.gpio;

import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SouthboundMqttGpioCallback
implements MqttCallbackExtended {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void connectComplete(boolean reconnect, String serverUri) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> [southbound mqtt gpio callback] start connectComplete >>>>>> ");
            this.logger.debug(" reconnect  : " + reconnect);
            this.logger.debug(" serverUri  : " + serverUri);
            this.logger.debug(" <<<<<<< [southbound mqtt gpio callback] end connectComplete <<<<<<< ");
        }
    }

    public void connectionLost(Throwable throwable) {
        this.logger.warn(" >>>>>> [southbound mqtt gpio callback] start connectionLost >>>>>> ");
        this.logger.error(" Connection lost with cause \"" + throwable.getMessage() + "\", Reason code : " + ((MqttException)throwable).getReasonCode() + "\" Cause : \"" + throwable.getCause() + "\"");
        this.logger.error(" error ", throwable);
        this.logger.warn(" <<<<<<< [southbound mqtt gpio callback] end connectionLost <<<<<<< ");
    }

    public void messageArrived(String topic, MqttMessage mqttMessage) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> [southbound mqtt gpio callback] start messageArrived >>>>>> ");
            this.logger.debug(" topic            : " + topic);
            if (mqttMessage != null && mqttMessage.getPayload() != null) {
                this.logger.debug(" messageId        : " + mqttMessage.getId());
                this.logger.debug(" messageContent   : " + new String(mqttMessage.getPayload()));
                this.logger.debug(" qos              : " + mqttMessage.getQos());
                this.logger.debug(" retained         : " + mqttMessage.isRetained());
                this.logger.debug(" duplicate        : " + mqttMessage.isDuplicate());
            } else {
                this.logger.debug(" mqttMessage is null ");
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" <<<<<<< [southbound mqtt gpio callback] end messageArrived <<<<<<< ");
        }
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> [southbound mqtt gpio callback] start deliveryComplete >>>>>> ");
            this.logger.debug(" deliveryComplete : " + token.isComplete());
            this.logger.debug(" <<<<<<< [southbound mqtt gpio callback] end deliveryComplete <<<<<<< ");
        }
    }
}

