package com.easesource.iot.datacenter.openservice;

import com.easesource.iot.datacenter.openservice.request.*;
import com.easesource.iot.datacenter.openservice.response.*;

import java.util.List;
import java.util.Map;

/**
 * 量测数据
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
public interface MeasDataService {

    /**
     * 获取量测点最新数据
     * @param measDataLatestGetRequest
     *          获取量测点最新数据请求
     * @return  获取量测点最新数据回应
     */
    MeasDataLatestGetResponse getMeasDataLatest(MeasDataLatestGetRequest measDataLatestGetRequest);

    /**
     * 批量获取量测点最新数据
     * @param measDataLatestBatchGetRequest
     *          批量获取量测点最新数据请求
     * @return  批量获取量测点最新数据回应
     */
    MeasDataLatestBatchGetResponse batchGetMeasDataLatest(MeasDataLatestBatchGetRequest measDataLatestBatchGetRequest);

    /**
     * 获取瞬时量离散数据（时间范围）
     * @param measDataInsDiscreteGetRangeRequest
     *          获取瞬时量离散数据请求
     * @return  获取瞬时量离散数据回应
     */
    MeasDataInsDiscreteGetRangeResponse getRangeMeasDataInsDiscrete(MeasDataInsDiscreteGetRangeRequest measDataInsDiscreteGetRangeRequest);

    /**
     * 获取瞬时量曲线数据（时间点）
     * @param measDataInsFreezeCurveGetRequest
     *          获取瞬时量曲线数据请求
     * @return  获取瞬时量曲线数据回应
     */
    MeasDataInsFreezeCurveGetResponse getMeasDataInsFreezeCurve(MeasDataInsFreezeCurveGetRequest measDataInsFreezeCurveGetRequest);

    /**
     * 获取瞬时量曲线数据（时间范围）
     * @param measDataInsFreezeCurveGetRangeRequest
     *          获取瞬时量曲线数据请求
     * @return  获取瞬时量曲线数据回应
     */
    MeasDataInsFreezeCurveGetRangeResponse getRangeMeasDataInsFreezeCurve(MeasDataInsFreezeCurveGetRangeRequest measDataInsFreezeCurveGetRangeRequest);

    /**
     * 批量获取瞬时量曲线数据（时间范围）
     * @param measDataInsFreezeCurveGetRangeRequest
     *          获取瞬时量曲线数据请求
     * @return  获取瞬时量曲线数据回应
     */
    MeasDataInsFreezeCurveGetRangeListResponse getRangeMeasDataInsFreezeCurveList(List<MeasDataInsFreezeCurveGetRangeRequest> measDataInsFreezeCurveGetRangeRequest);


    /**
     * 获取累计量离散数据（时间范围）
     * @param measDataCumDiscreteGetRangeRequest
     *          获取累计量离散数据请求
     * @return  获取累计量离散数据回应
     */
    MeasDataCumDiscreteGetRangeResponse getRangeMeasDataCumDiscrete(MeasDataCumDiscreteGetRangeRequest measDataCumDiscreteGetRangeRequest);

    /**
     * 获取累计量曲线数据（时间点）
     * @param measDataCumFreezeCurveGetRequest
     *          获取累计量曲线数据请求
     * @return  获取累计量曲线数据回应
     */
    MeasDataCumFreezeCurveGetResponse getMeasDataCumFreezeCurve(MeasDataCumFreezeCurveGetRequest measDataCumFreezeCurveGetRequest);

    /**
     * 批量（多量测点）获取累计量曲线数据（时间点）
     * @param measDataCumFreezeCurveBatchGetRequest
     *          批量（多量测点）获取累计量曲线数据请求
     * @return  批量（多量测点）获取累计量曲线数据回应
     */
    MeasDataCumFreezeCurveBatchGetResponse batchGetMeasDataCumFreezeCurve(MeasDataCumFreezeCurveBatchGetRequest measDataCumFreezeCurveBatchGetRequest);


    /**
     * 批量（多量测点）获取累计量曲线数据（多时间点）
     * @param measDataCumFreezeCurveBatchGetMTPsRequest
     *          批量（多量测点）获取累计量曲线数据请求
     * @return  批量（多量测点）获取累计量曲线数据回应
     */
    MeasDataCumFreezeCurveBatchGetMTPsResponse batchGetMTPsMeasDataCumFreezeCurve(MeasDataCumFreezeCurveBatchGetMTPsRequest measDataCumFreezeCurveBatchGetMTPsRequest);


    /**
     * 获取累计量曲线数据（时间范围）
     * @param measDataCumFreezeCurveGetRangeRequest
     *          获取累计量曲线数据请求
     * @return  获取累计量曲线数据回应
     */
    MeasDataCumFreezeCurveGetRangeResponse getRangeMeasDataCumFreezeCurve(MeasDataCumFreezeCurveGetRangeRequest measDataCumFreezeCurveGetRangeRequest);

    /**
     * 获取累计量日冻结数据（指定日期）
     * @param measDataCumFreezeDayGetRequest
     *          获取累计量日冻结数据请求
     * @return  获取累计量日冻结数据回应
     */
    MeasDataCumFreezeDayGetResponse getMeasDataCumFreezeDay(MeasDataCumFreezeDayGetRequest measDataCumFreezeDayGetRequest);

    /**
     * 获取累计量日冻结数据（日期范围）
     * @param measDataCumFreezeDayGetRangeRequest
     *          获取累计量日冻结数据请求
     * @return  获取累计量日冻结数据回应
     */
    MeasDataCumFreezeDayGetRangeResponse getRangeMeasDataCumFreezeDay(MeasDataCumFreezeDayGetRangeRequest measDataCumFreezeDayGetRangeRequest);

    /**
     * 获取状态量（布尔型）离散数据（时间范围）
     * @param measDataStateBoolDiscreteGetRangeRequest
     *          获取状态量（布尔型）离散数据请求
     * @return  获取状态量（布尔型）离散数据回应
     */
    MeasDataStateBoolDiscreteGetRangeResponse getRangeMeasDataStateBoolDiscrete(MeasDataStateBoolDiscreteGetRangeRequest measDataStateBoolDiscreteGetRangeRequest);

    /**
     * 获取状态量（字符型）离散数据（时间范围）
     * @param measDataStateCharDiscreteGetRangeRequest
     *          获取状态量（布尔型）离散数据请求
     * @return  获取状态量（布尔型）离散数据回应
     */
    MeasDataStateCharDiscreteGetRangeResponse getRangeMeasDataStateCharDiscrete(MeasDataStateCharDiscreteGetRangeRequest measDataStateCharDiscreteGetRangeRequest);

    /**
     * 获取统计量离散数据（时间范围）
     * @param measDataStatsDiscreteGetRangeRequest
     *          获取统计量离散数据请求
     * @return  获取统计量离散数据回应
     */
    MeasDataStatsDiscreteGetRangeResponse getRangeMeasDataStatsDiscrete(MeasDataStatsDiscreteGetRangeRequest measDataStatsDiscreteGetRangeRequest);

    /**
     * 获取告警量离散数据（时间范围）
     * @param measDataAlarmDiscreteGetRangeRequest
     *          获取告警量离散数据请求
     * @return  获取告警量离散数据回应
     */
    MeasDataAlarmDiscreteGetRangeResponse getRangeMeasDataAlarmDiscrete(MeasDataAlarmDiscreteGetRangeRequest measDataAlarmDiscreteGetRangeRequest);

}
