package com.easesource.iot.datacenter.openservice;

import com.easesource.iot.datacenter.openservice.entity.MeasDataCumFreezeCurveDo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataInsFreezeCurveDo;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 量测数据存储服务
 *
 * @author Nick Zhang
 * @date 2019-05-14
 */
public interface MeasDataStoreService {

    /**
     * 更新一行数据，如果原行不存在，会新写入一行。
     * 更新操作包括写入某列、删除某列和删除某列的某一版本。
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCode
     *          量测项编码
     * @param measDataInfo
     *          量测数据信息
     */
    void updateMeasDataLatest(Long measPointId, String measItemCode, Map<String, Object> measDataInfo);

    /**
     * 批量更新数据
     *
     * @param batchMeasDataInfosMap
     *          批量量测数据信息Map
     */
    void batchUpdateMeasDataLatest(Map<Long, Map<String, Map<String, Object>>> batchMeasDataInfosMap);

    /**
     * 删除一行数据
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCode
     *          量测项编码
     */
    void deleteMeasDataLatest(Long measPointId, String measItemCode);

    void insertOrUpdateMeasDataCumFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze, BigDecimal measDataValue, BigDecimal measDataRate, int measDataSource, long gmtMeasData, int freezeMode);

    void batchInsertOrUpdateMeasDataCumFreezeCurve(List<MeasDataCumFreezeCurveDo> measDataCumFreezeCurveDoList);

    /**
     * 删除一行数据
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCode
     *          量测项编码
     * @param gmtMeasFreeze
     *          量测冻结时间
     */
    void deleteMeasDataCumFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze);

    /**
     * 批量删除一天数据
     *
     * @param measPointIds
     *          量测点标识
     * @param gmtMeasFreeze
     *          量测冻结时间开始时间
     * @param gmtMeasFreezeEnd
     *          量测冻结时间结束时间
     */
    void deleteMeasDataCumFreezeCurveDay(Set<Long> measPointIds, long gmtMeasFreeze, long gmtMeasFreezeEnd);

    void insertOrUpdateMeasDataInsFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze, BigDecimal measDataValue, BigDecimal measDataRate, int measDataSource, long gmtMeasData, int freezeMode);

    void batchInsertOrUpdateMeasDataInsFreezeCurve(List<MeasDataInsFreezeCurveDo> measDataInsFreezeCurveDoList);

    /**
     * 删除一行数据
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCode
     *          量测项编码
     * @param gmtMeasFreeze
     *          量测冻结时间
     */
    void deleteMeasDataInsFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze);

    /**
     * 批量删除一天数据
     *
     * @param measPointIds
     *          量测点标识
     * @param gmtMeasFreeze
     *          量测冻结时间开始时间
     * @param gmtMeasFreezeEnd
     *          量测冻结时间结束时间
     */
    void deleteMeasDataInsFreezeCurveDay(Set<Long> measPointIds, long gmtMeasFreeze, long gmtMeasFreezeEnd);
}
