package com.easesource.iot.datacenter.openservice;

import com.easesource.iot.datacenter.openservice.request.*;
import com.easesource.iot.datacenter.openservice.response.*;

/**
 * 量测统计数据
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
public interface MeasStatService {

    /**
     * 获取瞬时量日统计数据（单个日期）
     * @param measStatInsDayGetRequest
     *          获取瞬时量日统计数据请求
     * @return  获取瞬时量日统计数据回应
     */
    MeasStatInsDayGetResponse getMeasStatInsDay(MeasStatInsDayGetRequest measStatInsDayGetRequest);

    /**
     * 批量获取瞬时量日统计数据（单个日期）
     * @param measStatInsDayBatchGetRequest
     *          获取瞬时量日统计数据请求
     * @return  获取瞬时量日统计数据回应
     */
    MeasStatInsDayBatchGetResponse batchGetMeasStatInsDay(MeasStatInsDayBatchGetRequest measStatInsDayBatchGetRequest);

    /**
     * 获取瞬时量日统计数据（日期范围）
     * @param measStatInsDayGetRangeRequest
     *          获取瞬时量日统计数据请求
     * @return  获取瞬时量日统计数据回应
     */
    MeasStatInsDayGetRangeResponse getRangeMeasStatInsDay(MeasStatInsDayGetRangeRequest measStatInsDayGetRangeRequest);

    /**
     * 批量获取瞬时量日统计数据（日期范围）
     * @param measStatInsDayBatchGetRangeRequest
     *          获取瞬时量日统计数据请求
     * @return  获取瞬时量日统计数据回应
     */
    MeasStatInsDayBatchGetRangeResponse batchGetRangeMeasStatInsDay(MeasStatInsDayBatchGetRangeRequest measStatInsDayBatchGetRangeRequest);

    /**
     * 获取瞬时量月统计数据（单个月份）
     * @param measStatInsMonthGetRequest
     *          获取瞬时量月统计数据请求
     * @return  获取瞬时量月统计数据回应
     */
    MeasStatInsMonthGetResponse getMeasStatInsMonth(MeasStatInsMonthGetRequest measStatInsMonthGetRequest);

    /**
     * 批量获取瞬时量月统计数据（单个月份）
     * @param measStatInsMonthBatchGetRequest
     *          获取瞬时量月统计数据请求
     * @return  获取瞬时量月统计数据回应
     */
    MeasStatInsMonthBatchGetResponse batchGetMeasStatInsMonth(MeasStatInsMonthBatchGetRequest measStatInsMonthBatchGetRequest);

    /**
     * 获取瞬时量月统计数据（月份范围）
     * @param measStatInsMonthGetRangeRequest
     *          获取瞬时量月统计数据请求
     * @return  获取瞬时量月统计数据回应
     */
    MeasStatInsMonthGetRangeResponse getRangeMeasStatInsMonth(MeasStatInsMonthGetRangeRequest measStatInsMonthGetRangeRequest);

    /**
     * 批量获取瞬时量月统计数据（月份范围）
     * @param measStatInsMonthBatchGetRangeRequest
     *          获取瞬时量月统计数据请求
     * @return  获取瞬时量月统计数据回应
     */
    MeasStatInsMonthBatchGetRangeResponse batchGetRangeMeasStatInsMonth(MeasStatInsMonthBatchGetRangeRequest measStatInsMonthBatchGetRangeRequest);

    /**
     * 获取瞬时量年统计数据（单个年份）
     * @param measStatInsYearGetRequest
     *          获取瞬时量年统计数据请求
     * @return  获取瞬时量年统计数据回应
     */
    MeasStatInsYearGetResponse getMeasStatInsYear(MeasStatInsYearGetRequest measStatInsYearGetRequest);

    /**
     * 批量获取瞬时量年统计数据（单个年份）
     * @param measStatInsYearBatchGetRequest
     *          获取瞬时量年统计数据请求
     * @return  获取瞬时量年统计数据回应
     */
    MeasStatInsYearBatchGetResponse batchGetMeasStatInsYear(MeasStatInsYearBatchGetRequest measStatInsYearBatchGetRequest);

    /**
     * 获取瞬时量年统计数据（年份范围）
     * @param measStatInsYearGetRangeRequest
     *          获取瞬时量年统计数据请求
     * @return  获取瞬时量年统计数据回应
     */
    MeasStatInsYearGetRangeResponse getRangeMeasStatInsYear(MeasStatInsYearGetRangeRequest measStatInsYearGetRangeRequest);

    /**
     * 获取瞬时量年统计数据（年份范围）
     * @param measStatInsYearBatchGetRangeRequest
     *          获取瞬时量年统计数据请求
     * @return  获取瞬时量年统计数据回应
     */
    MeasStatInsYearBatchGetRangeResponse batchGetRangeMeasStatInsYear(MeasStatInsYearBatchGetRangeRequest measStatInsYearBatchGetRangeRequest);

    /**
     * 获取累计量日统计数据（单个日期）
     * @param measStatCumDayGetRequest
     *          获取累计量日统计数据请求
     * @return  获取累计量日统计数据回应
     */
    MeasStatCumDayGetResponse getMeasStatCumDay(MeasStatCumDayGetRequest measStatCumDayGetRequest);

    /**
     * 获取累计量日统计数据（单个日期）
     * @param measStatCumDayBatchGetRequest
     *          获取累计量日统计数据请求
     * @return  获取累计量日统计数据回应
     */
    MeasStatCumDayBatchGetResponse batchGetMeasStatCumDay(MeasStatCumDayBatchGetRequest measStatCumDayBatchGetRequest);

    /**
     * 获取累计量日统计数据（日期范围）
     * @param measStatCumDayGetRangeRequest
     *          获取累计量日统计数据请求
     * @return  获取累计量日统计数据回应
     */
    MeasStatCumDayGetRangeResponse getRangeMeasStatCumDay(MeasStatCumDayGetRangeRequest measStatCumDayGetRangeRequest);

    /**
     * 获取累计量日统计数据（日期范围） 光日使用量
     * @param measStatCumDayGetRangeRequest
     *          获取累计量日统计数据请求
     * @return  获取累计量日统计数据回应
     */
    MeasStatCumDayGetRangeResponse getRangeMeasStatCumDayForUsageDval(MeasStatCumDayGetRangeRequest measStatCumDayGetRangeRequest);

    /**
     * 获取累计量日统计数据（日期范围）
     * @param measStatCumDayBatchGetRangeRequest
     *          获取累计量日统计数据请求
     * @return  获取累计量日统计数据回应
     */
    MeasStatCumDayBatchGetRangeResponse batchGetRangeMeasStatCumDay(MeasStatCumDayBatchGetRangeRequest measStatCumDayBatchGetRangeRequest);

    /**
     * 获取累计量月统计数据（单个月份）
     * @param measStatCumMonthGetRequest
     *          获取累计量月统计数据请求
     * @return  获取累计量月统计数据回应
     */
    MeasStatCumMonthGetResponse getMeasStatCumMonth(MeasStatCumMonthGetRequest measStatCumMonthGetRequest);

    /**
     * 批量获取累计量月统计数据（单个月份）
     * @param measStatCumMonthBatchGetRequest
     *          获取累计量月统计数据请求
     * @return  获取累计量月统计数据回应
     */
    MeasStatCumMonthBatchGetResponse batchGetMeasStatCumMonth(MeasStatCumMonthBatchGetRequest measStatCumMonthBatchGetRequest);

    /**
     * 获取累计量月统计数据（月份范围）
     * @param measStatCumMonthGetRangeRequest
     *          获取累计量月统计数据请求
     * @return  获取累计量月统计数据回应
     */
    MeasStatCumMonthGetRangeResponse getRangeMeasStatCumMonth(MeasStatCumMonthGetRangeRequest measStatCumMonthGetRangeRequest);

    /**
     * 批量获取累计量月统计数据（月份范围）
     * @param measStatCumMonthBatchGetRangeRequest
     *          获取累计量月统计数据请求
     * @return  获取累计量月统计数据回应
     */
    MeasStatCumMonthBatchGetRangeResponse batchGetRangeMeasStatCumMonth(MeasStatCumMonthBatchGetRangeRequest measStatCumMonthBatchGetRangeRequest);

    /**
     * 获取累计量年统计数据（单个年份）
     * @param measStatCumYearGetRequest
     *          获取累计量年统计数据请求
     * @return  获取累计量年统计数据回应
     */
    MeasStatCumYearGetResponse getMeasStatCumYear(MeasStatCumYearGetRequest measStatCumYearGetRequest);

    /**
     * 批量获取累计量年统计数据（单个年份）
     * @param measStatCumYearBatchGetRequest
     *          获取累计量年统计数据请求
     * @return  获取累计量年统计数据回应
     */
    MeasStatCumYearBatchGetResponse batchGetMeasStatCumYear(MeasStatCumYearBatchGetRequest measStatCumYearBatchGetRequest);

    /**
     * 获取累计量年统计数据（年份范围）
     * @param measStatCumYearGetRangeRequest
     *          获取累计量年统计数据请求
     * @return  获取累计量年统计数据回应
     */
    MeasStatCumYearGetRangeResponse getRangeMeasStatCumYear(MeasStatCumYearGetRangeRequest measStatCumYearGetRangeRequest);

    /**
     * 获取累计量年统计数据（年份范围）
     * @param measStatCumYearBatchGetRangeRequest
     *          获取累计量年统计数据请求
     * @return  获取累计量年统计数据回应
     */
    MeasStatCumYearBatchGetRangeResponse batchGetRangeMeasStatCumYear(MeasStatCumYearBatchGetRangeRequest measStatCumYearBatchGetRangeRequest);

}
