package com.easesource.iot.datacenter.openservice.constant;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-04
 */
public enum DevEntityLogTypeEnum {

    /**
     *
     */
    CREATE(1, "新增"),
    UPDATE(2, "修改"),
    DELETE(3, "删除");

    private int type;
    private String name;

    DevEntityLogTypeEnum(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static DevEntityLogTypeEnum getNameByType(int type) {
        for(DevEntityLogTypeEnum devEntityLogTypeEnum : values()) {
            if(type == devEntityLogTypeEnum.getType()) {
                return devEntityLogTypeEnum;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "DevEntityLogTypeEnum{" +
                "type=" + type +
                ", name='" + name + '\'' +
                '}';
    }

}
