package com.easesource.iot.datacenter.openservice.constant;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-04
 */
public enum DevLifeStateEnum {

    /**
     *
     */
    INVENTORY("00", "库存"),
    INSTALLED("02", "已装（待运行）"),
    RUNNING("03", "运行"),
    DISMANTLED("07", "拆除"),
    CANCELLED("09", "注销");

    private String code;
    private String name;

    DevLifeStateEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static DevLifeStateEnum getNameByCode(String code) {
        for(DevLifeStateEnum devLifeStateEnum : values()) {
            if(code.equals(devLifeStateEnum.getCode())) {
                return devLifeStateEnum;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "DevLifeStateEnum{" +
                "code='" + code + '\'' +
                ", name='" + name + '\'' +
                '}';
    }

}
