package com.easesource.iot.datacenter.openservice.constant;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-04
 */
public enum DevLifeStateLogTypeEnum {

    /**
     *
     */
    ARRIVAL(11, "入库"),
    INSTALL(12, "安装"),
    GOTORUN(13, "投运"),
    DISMANTLE(14, "拆除"),
    ARCHIVE(15, "归档");

    private int type;
    private String name;

    DevLifeStateLogTypeEnum(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static DevLifeStateLogTypeEnum getNameByType(int type) {
        for(DevLifeStateLogTypeEnum devEntityLogTypeEnum : values()) {
            if(type == devEntityLogTypeEnum.getType()) {
                return devEntityLogTypeEnum;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "DevEntityLogTypeEnum{" +
                "type=" + type +
                ", name='" + name + '\'' +
                '}';
    }

}
