package com.easesource.iot.datacenter.openservice.constant;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-03
 */
public enum MeasItemSubtypeEnum {

    /**
     *
     */
    INS("INS", "瞬时量"),
    CUM("CUM", "累计量"),
    STATE_BOOL("STATE_BOOL", "状态量（布尔型）"),
    STATE_CHAR("STATE_CHAR", "状态量（字符型）"),
    STATS_SUM("STATS_SUM", "合计值（统计量）"),
    STATS_CNT("STATS_CNT", "计数值（统计量）"),
    STATS_AVG("STATS_AVG", "平均值（统计量）"),
    STATS_MAX("STATS_MAX", "最大值（统计量）"),
    STATS_MIN("STATS_MIN", "最小值（统计量）"),
    STATS_OTH("STATS_OTH", "其他值（统计量）"),
    ALARM("ALARM", "告警量");

    private String code;
    private String name;

    MeasItemSubtypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static MeasItemSubtypeEnum getNameByCode(String code) {
        for(MeasItemSubtypeEnum measItemSubtypeEnum : values()) {
            if(code.equals(measItemSubtypeEnum.getCode())) {
                return measItemSubtypeEnum;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "MeasItemSubtypeEnum{" +
                "code='" + code + '\'' +
                ", name='" + name + '\'' +
                '}';
    }

}
