package com.easesource.iot.datacenter.openservice.constant;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-03
 */
public enum MeasItemTypeEnum {

    /**
     *
     */
    INS("INS", "瞬时量"),
    CUM("CUM", "累计量"),
    STATE_BOOL("STATE_BOOL", "状态量（布尔型）"),
    STATE_CHAR("STATE_CHAR", "状态量（字符型）"),
    STATS("STATS", "统计量"),
    ALARM("ALARM", "告警量");

    private String code;
    private String name;

    MeasItemTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static MeasItemTypeEnum getNameByCode(String code) {
        for(MeasItemTypeEnum measItemTypeEnum : values()) {
            if(code.equals(measItemTypeEnum.getCode())) {
                return measItemTypeEnum;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "MeasItemTypeEnum{" +
                "code='" + code + '\'' +
                ", name='" + name + '\'' +
                '}';
    }

}
