package com.easesource.iot.datacenter.openservice.constant;

/**
 *
 * @author Nick Zhang
 * @date 2019-10-30
 */
public enum UpcommTypeEnum {

    /**
     *
     */
    TCP_SOCKET(10, "TCP"),
    TCP_MQTT(11, "MQTT"),
    TCP_HTTP(12, "HTTP"),
    UDP_SOCKET(20, "UDP"),
    UDP_COAP(21, "CoAP"),
    UDP_LWM2M(22, "LwM2M");

    private int type;
    private String name;

    UpcommTypeEnum(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static UpcommTypeEnum getNameByType(int type) {
        for(UpcommTypeEnum upcommTypeEnum : values()) {
            if(type == upcommTypeEnum.getType()) {
                return upcommTypeEnum;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "UpcommTypeEnum{" +
            "type=" + type +
            ", name='" + name + '\'' +
            '}';
    }
}
