package com.easesource.iot.datacenter.openservice.entity;

import com.easesource.iot.datacenter.openservice.constant.*;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-04
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class LogDevAccessEntityDo implements Serializable {

    private static final long serialVersionUID = 8102633733096453740L;

    /**
     * 变更日志标识
     */
    private Long id;

    /**
     * 变更日志类型
     * @see DevEntityLogTypeEnum
     */
    private int logType;

    /**
     * 接入设备标识
     */
    private Long devAccessId;

    /**
     * 变更前设备资产实体信息：JSON字符串
     */
    private String oldEntity;

    /**
     * 变更后设备资产实体信息：JSON字符串
     */
    private String newEntity;

    /**
     * 变更途径
     * @see LogAlterPathwayEnum
     */
    private String alterPathway;

    /**
     * 变更人
     */
    private String alterOper;

    /**
     * 变更时间
     */
    private long gmtAlter;

}
