package com.easesource.iot.datacenter.openservice.entity;

import com.easesource.iot.datacenter.openservice.constant.DevLifeStateEnum;
import com.easesource.iot.datacenter.openservice.constant.DevLifeStateLogTypeEnum;
import com.easesource.iot.datacenter.openservice.constant.LogAlterPathwayEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-04
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class LogDevAccessLifeDo implements Serializable {

    private static final long serialVersionUID = 6608471324818580002L;

    /**
     * 变更日志标识
     */
    private Long id;

    /**
     * 变更日志类型
     * @see DevLifeStateLogTypeEnum
     */
    private int logType;

    /**
     * 接入设备标识
     */
    private Long devAccessId;

    /**
     * 变更前生命周期状态
     * @see DevLifeStateEnum
     */
    private String oldLifeState;

    /**
     * 变更后生命周期状态
     * @see DevLifeStateEnum
     */
    private String newLifeState;

    /**
     * 变更途径
     * @see LogAlterPathwayEnum
     */
    private String alterPathway;

    /**
     * 变更人
     */
    private String alterOper;

    /**
     * 变更时间
     */
    private long gmtAlter;

}
