package com.easesource.iot.datacenter.openservice.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 累计量曲线数据值
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MeasDataCumFreezeCurveValue implements Serializable {

    private static final long serialVersionUID = -1657888016554203270L;

    /**
     * 量测点标识
     */
    private Long measPointId;

    /**
     * 量测项编码
     */
    private String measItemCode;

    /**
     * 量测曲线时间
     */
    private long gmtMeasFreeze;

    /**
     * 量测数据值（累计量）
     */
    private BigDecimal measDataValue;

    /**
     * 量测数据倍率值（业务上的一次测和二次侧数据的比率关系）
     */
    private BigDecimal measDataRate;

    /**
     * 量测数据来源
     * 0 – 设备上送；
     * 1 – 主站任务；
     * 2 – 设备告警；
     * 3 – 漏点补召；
     * 10 – 手工录入；
     * 11 – 估算数据；
     * 12 – 模拟数据；
     * 20 – 计算数据；
     */
    private int measDataSource;

    /**
     * 曲线冻结方式
     * 0 – 离散数据定时冻结；
     * 1 – 设备冻结数据；
     */
    private int freezeMode;

    /**
     * 量测数据时间（抄表时间）
     */
    private long gmtMeasDataReading;

    /**
     * 创建时间
     */
    private long gmtCreate;

    /**
     * 更新时间
     */
    private long gmtModified;

}
