package com.easesource.iot.datacenter.openservice.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 状态量（布尔型）离散数据值
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MeasDataStateBoolDiscreteValue implements Serializable {

    private static final long serialVersionUID = -721933195904212189L;

    /**
     * 量测点标识
     */
    private Long measPointId;

    /**
     * 量测项编码
     */
    private String measItemCode;

    /**
     * 量测数据时间
     */
    private long gmtMeasData;

    /**
     * 量测数据值（状态量）
     */
    private Boolean measDataValue;

    /**
     * 量测数据来源
     * 0 – 设备上送；
     * 1 – 主站任务；
     * 2 – 设备告警；
     * 3 – 漏点补召；
     * 10 – 手工录入；
     * 11 – 估算数据；
     * 12 – 模拟数据；
     * 20 – 计算数据；
     */
    private int measDataSource;

    /**
     * 创建时间
     */
    private long gmtCreate;

    /**
     * 更新时间
     */
    private long gmtModified;

}
