package com.easesource.iot.datacenter.openservice.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 统计量离散数据值
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MeasDataStatsDiscreteValue implements Serializable {

    private static final long serialVersionUID = 8327262319092271446L;

    /**
     * 量测点标识
     */
    private Long measPointId;

    /**
     * 量测项编码
     */
    private String measItemCode;

    /**
     * 量测数据时间
     */
    private long gmtMeasData;

    /**
     * 统计值
     */
    private BigDecimal statsValue;

    /**
     * 统计值类型
     *      0 - 无变比；
     *      1 - 一次值；
     *      2 - 二次值；
     */
    private int statsValueType;

    /**
     * 量测数据倍率值（业务上的一次测和二次侧数据的比率关系）
     */
    private BigDecimal measDataRate;

    /**
     * 统计最值发生时间（最大值、最小值发生时间）
     */
    private Date timeStatsValue;

    /**
     * 统计类型
     * STATS_SUM
     *      累计值（统计量）
     * STATS_CNT
     *      计数值（统计量）
     * STATS_AVG
     *      平均值（统计量）
     * STATS_MAX
     *      最大值（统计量）
     * STATS_MIN
     *      最小值（统计量）
     * STATS_OTH
     *      其他值（统计量）
     */
    private String statsType;

    /**
     * 统计时间范围
     * 10 – 当日
     * 11 – 上一日
     * 12 – 上二日
     * 13 – 上三日
     * 20 – 当月
     * 21 – 上一月
     * 22 – 上二月
     * 23 – 上三月
     * 30 – 当年
     * 31 – 上一年
     * 32 – 上二年
     * 33 – 上三年
     */
    private int statsTimeRange;

    /**
     * 量测数据来源
     * 0 – 设备上送；
     * 1 – 主站任务；
     * 2 – 设备告警；
     * 3 – 漏点补召；
     * 10 – 手工录入；
     * 11 – 估算数据；
     * 12 – 模拟数据；
     * 20 – 计算数据；
     */
    private int measDataSource;

    /**
     * 创建时间
     */
    private long gmtCreate;

    /**
     * 更新时间
     */
    private long gmtModified;

}
