package com.easesource.iot.datacenter.openservice.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 定时任务，对应数据库ease_iotdata中的meas_data_task
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MeasDataTaskDo implements Serializable {
    private Long id;

    /**
     * cron表达式
     */
    private String cron;

    /**
     * 任务类型：1-累计曲线，0-冻结曲线
     */
    private String taskType;


    /**
     * 名称 或 标注
     */
    private String taskFlg;

    /**
     * 系统单位编号
     */
    private String orgNo;

    /**
     * 分组名称
     */
    private String groupName;


    /**
     * 要执行的类名称
     */
    private String clazzName;


    /**
     * 清除多少日期前的数据
     */
    private String clearDays;
}
