package com.easesource.iot.datacenter.openservice.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 累计量日统计数据
 *
 * @author Nick Zhang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MeasStatCumDayValue implements Serializable {

    private static final long serialVersionUID = -1971652924442369171L;

    /**
     * 量测点标识
     */
    private Long measPointId;

    /**
     * 量测项编码
     */
    private String measItemCode;

    /**
     * 统计日期
     *  格式 yyyyMMdd
     */
    private String dateMeasStat;

    /**
     * 量测数据倍率值（业务上的一次测和二次侧数据的比率关系）
     */
    private BigDecimal measDataRate;

    /**
     * 日起始值
     */
    private BigDecimal startDval;

    /**
     * 日起始值时间
     */
    private long gmtStartDval;

    /**
     * 日截止值
     */
    private BigDecimal endDval;

    /**
     * 日截止值时间
     */
    private long gmtEndDval;

    /**
     * 日使用量
     */
    private BigDecimal usageDval;

    /**
     * 一刻钟使用量数组（15分钟间隔，96个点）
     */
    private BigDecimal[] usageQvals;

    /**
     * meas_data_cum_freeze_curve 累计量曲线数据表名（默认）
     * 或
     * meas_data_stats_discrete 统计量离散数据表名
     */
    private String statDataSource;

    /**
     * 创建时间
     */
    private long gmtCreate;

    /**
     * 更新时间
     */
    private long gmtModified;

}
