package com.easesource.iot.datacenter.openservice.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 累计量月统计数据
 *
 * @author Nick Zhang
 * @date 2019-04-03
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MeasStatCumMonthValue implements Serializable {

    private static final long serialVersionUID = -2846122963830775615L;

    /**
     * 量测点标识
     */
    private Long measPointId;

    /**
     * 量测项编码
     */
    private String measItemCode;

    /**
     * 统计月份
     *  格式 yyyyMM
     */
    private String monthMeasStat;

    /**
     * 量测数据倍率值（业务上的一次测和二次侧数据的比率关系）
     */
    private BigDecimal measDataRate;

    /**
     * 月起始值
     */
    private BigDecimal startMval;

    /**
     * 月起始值时间
     */
    private long gmtStartMval;

    /**
     * 月截止值
     */
    private BigDecimal endMval;

    /**
     * 月截止值时间
     */
    private long gmtEndMval;

    /**
     * 月使用量
     */
    private BigDecimal usageMval;

    /**
     * 日使用量数组
     */
    private BigDecimal[] usageDvals;

    /**
     * meas_stat_cum_day 累计量日统计数据表名（默认）
     * 或
     * meas_data_cum_freeze_curve 累计量曲线数据表名
     * 或
     * meas_data_stats_discrete 统计量离散数据表名
     */
    private String statDataSource;

    /**
     * 创建时间
     */
    private long gmtCreate;

    /**
     * 更新时间
     */
    private long gmtModified;

}
