package com.easesource.iot.datacenter.openservice.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 瞬时量年统计数据
 *
 * @author Nick Zhang
 * @date 2019-04-03
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MeasStatInsYearValue implements Serializable {

    private static final long serialVersionUID = 5252959818672727944L;

    /**
     * 量测点标识
     */
    private Long measPointId;

    /**
     * 量测项编码
     */
    private String measItemCode;

    /**
     * 统计年份
     *  格式 yyyy
     */
    private String yearMeasStat;

    /**
     * 量测数据倍率值（业务上的一次测和二次侧数据的比率关系）
     */
    private BigDecimal measDataRate;

    /**
     * 平均值
     */
    private BigDecimal avgValue;

    /**
     * 最大值
     */
    private BigDecimal maxValue;

    /**
     * 最大值发生时间
     */
    private long gmtMaxValue;

    /**
     * 最小值
     */
    private BigDecimal minValue;

    /**
     * 最小值发生时间
     */
    private long gmtMinValue;

    /**
     * meas_stat_ins_day 瞬时量日统计数据表名（默认）
     * 或
     * meas_data_ins_freeze_curve 瞬时量曲线数据表名
     * 或
     * meas_data_stats_discrete 统计量离散数据表名
     */
    private String statDataSource;

    /**
     * 统计数据数量
     */
    private int statDataCount;

    /**
     * 创建时间
     */
    private long gmtCreate;

    /**
     * 更新时间
     */
    private long gmtModified;

}
