package com.easesource.iot.datacenter.openservice.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-04
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RunMeasPointChangeLogDo implements Serializable {

    private static final long serialVersionUID = 7141658087277268781L;

    /**
     * 量测点标识
     */
    private Long id;

    /**
     * 终端编号
     */
    private String sn;

    /**
     * 系统单位编号
     */
    private String orgNo;

    /**
     * 接入量测设备标识
     */
    private Long accessMeasureId;

    /**
     * 接入网关设备标识
     */
    private Long accessGatewayId;


    /**
     * 量测通信地址
     */
    private String measCommAddr;

    /**
     * 创建时间
     */
    private long gmtCreate;

    /**
     * 更新时间
     */
    private long gmtModified;

    /**
     * 版本号，用于乐观锁
     */
    private int version;

}
