package com.easesource.iot.datacenter.openservice.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-04
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RunMeasPointDo implements Serializable {

    private static final long serialVersionUID = 7141658087277268781L;

    /**
     * 量测点标识
     */
    private Long id;

    /**
     * 系统单位编号
     */
    private String orgNo;

    /**
     * 接入量测设备标识
     */
    private Long accessMeasureId;

    /**
     * 接入中继设备标识
     */
    private Long accessTrunkingId;

    /**
     * 接入网关设备标识
     */
    private Long accessGatewayId;

    /**
     * 量测点性质
     */
    private int measKind;

    /**
     * 量测点序号
     */
    private int measSn;

    /**
     * 量测通信方式
     */
    private String measCommMode;

    /**
     * 量测通信规约
     */
    private String measCommProto;

    /**
     * 量测通信地址
     */
    private String measCommAddr;

    /**
     * 量测通信端口
     */
    private int measCommPort;

    /**
     * 量测通信参数
     */
    private String measCommParam;

    /**
     * 最近一次报文上行时间
     */
    private long gmtMessageUp;

    /**
     * 最近一次量测数据上行时间
     */
    private long gmtMeasdataUp;

    /**
     * 最近一次告警上行时间
     */
    private long gmtAlarmUp;

    /**
     * 创建时间
     */
    private long gmtCreate;

    /**
     * 更新时间
     */
    private long gmtModified;

    /**
     * 版本号，用于乐观锁
     */
    private int version;

}
