package com.easesource.iot.datacenter.openservice.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-04
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RunMeasPointVo implements Serializable {

    private static final long serialVersionUID = -7659374024830083545L;

    /**
     * 量测点标识
     */
    private Long id;

    /**
     * 系统单位编号
     */
    private String orgNo;

    /**
     * 接入量测设备标识
     */
    private Long accessMeasureId;

    /**
     * 接入量测设备分类编号
     */
    private String accessMeasureSortNo;

    /**
     * 接入量测设备编号
     */
    private String accessMeasureNo;

    /**
     * 接入量测设备名称
     */
    private String accessMeasureName;

    /**
     * 接入量测设备说明
     */
    private String accessMeasureDesc;

    /**
     * 接入量测设备详情
     */
    private String accessMeasureDetail;

    /**
     * 接入量测设备生产厂家
     */
    private String accessMeasureMfrCode;

    /**
     * 接入量测设备型号
     */
    private String accessMeasureModelCode;

    /**
     * 接入中继设备标识
     */
    private Long accessTrunkingId;

    /**
     * 接入中继设备地址
     */
    private String trunkCommAddr;

    /**
     * 接入网关设备标识
     */
    private Long accessGatewayId;

    /**
     * 接入网关设备编号
     */
    private String accessGatewayNo;

    /**
     * 接入网关设备名称
     */
    private String accessGatewayName;

    /**
     *
     */
    private String upcommProto;

    /**
     *
     */
    private String upcommProtoVer;

    /**
     *
     */
    private String upcommLogicAddr;

    /**
     *
     */
    private int upcommType;

    /**
     *
     */
    private String upcommParam;

    /**
     * 量测点性质
     */
    private int measKind;

    /**
     * 量测点序号
     */
    private int measSn;

    /**
     * 量测通信方式
     */
    private String measCommMode;

    /**
     * 量测通信规约
     */
    private String measCommProto;

    /**
     * 量测通信地址
     */
    private String measCommAddr;

    /**
     * 是否用电
     */
    private boolean enableElec;

    /**
     * 用电相数，1 - 单相；3 - 三相；
     */
    private int elecPhaseCount;

    /**
     * 是否用水
     */
    private boolean enableWater;

    /**
     * 是否用气
     */
    private boolean enableGas;

    /**
     * 是否用热
     */
    private boolean enableHeat;

    /**
     * 是否用汽
     */
    private boolean enableSteam;

    /**
     * 量测通信端口
     */
    private int measCommPort;

    /**
     * 量测通信参数
     */
    private String measCommParam;

    /**
     * 最近一次报文上行时间
     */
    private long gmtMessageUp;

    /**
     * 最近一次量测数据上行时间
     */
    private long gmtMeasdataUp;

    /**
     * 最近一次告警上行时间
     */
    private long gmtAlarmUp;

    /**
     * 创建时间
     */
    private long gmtCreate;

    /**
     * 更新时间
     */
    private long gmtModified;

    /**
     * 版本号，用于乐观锁
     */
    private int version;

}
