package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.DevAccessGatewayQueryResponse;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-04
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DevAccessGatewayQueryRequest implements BaseRequest<DevAccessGatewayQueryResponse> {

    private static final long serialVersionUID = -8249970502551092640L;

    /**
     * 接入设备标识Set
     * 可以为空
     */
    private Set<Long> devAccessIdSet;

    /**
     * 系统单位编号Set
     * 可以为空
     */
    private Set<String> orgNoSet;

    /**
     * 接入设备分类编号Set
     * 可以为空
     */
    private Set<String> devAccessSortNoSet;

    /**
     * 接入设备编号Set
     * 可以为空
     */
    private Set<String> devAccessNoSet;

    /**
     * 上行通讯规约Set
     * 可以为空
     */
    private Set<String> upcommProtoSet;

    /**
     * 上行通讯规约版本Set
     * 可以为空
     */
    private Set<String> upcommProtoVerSet;

    /**
     * 上行通讯逻辑地址Set
     * 可以为空
     */
    private Set<String> upcommLogicAddrSet;

    /**
     * 生命周期状态Set
     * 可以为空
     */
    private Set<String> lifeStateSet;

    /**
     * 接入设备名称（模糊查询）
     * 可以为空
     * 说明：不允许单独使用，需与上述条件组合使用
     */
    private String devAccessNameFuzzy;

    /**
     * 上行通讯逻辑地址（模糊查询）
     * 可以为空
     * 说明：不允许单独使用，需与上述条件组合使用
     */
    private String upcommLogicAddrFuzzy;

    @Override
    public Class<DevAccessGatewayQueryResponse> getResponseClass() {
        return DevAccessGatewayQueryResponse.class;
    }

}
