package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.MeasDataCumFreezeCurveBatchGetMTPsResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataCumFreezeCurveBatchGetResponse;
import lombok.*;

import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@RequiredArgsConstructor
public class MeasDataCumFreezeCurveBatchGetMTPsRequest implements BaseRequest<MeasDataCumFreezeCurveBatchGetMTPsResponse> {

    private static final long serialVersionUID = 6735186912716087795L;

    /**
     * 量测点标识Set
     */
    @NonNull
    private Set<Long> measPointIdSet;

    /**
     * 量测项编码Set
     */
    @NonNull
    private Set<String> measItemCodeSet;

    /**
     * 量测曲线时间
     */
    @NonNull
    private Set<Long> gmtMeasFreezeSet;

    /**
     * 量测数据类型（默认二次侧值）
     * 1 - 一次侧值；
     * 2 - 二次侧值；
     */
    private int measDataSideType = 2;

    @Override
    public Class<MeasDataCumFreezeCurveBatchGetMTPsResponse> getResponseClass() {
        return MeasDataCumFreezeCurveBatchGetMTPsResponse.class;
    }

}
