package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.MeasDataCumFreezeCurveBatchGetResponse;
import lombok.*;

import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@RequiredArgsConstructor
public class MeasDataCumFreezeCurveBatchGetRequest implements BaseRequest<MeasDataCumFreezeCurveBatchGetResponse> {

    private static final long serialVersionUID = 6735186912716087795L;

    /**
     * 量测点标识Set
     */
    @NonNull
    private Set<Long> measPointIdSet;

    /**
     * 量测项编码Set
     */
    @NonNull
    private Set<String> measItemCodeSet;

    /**
     * 量测曲线时间
     */
    @NonNull
    private long gmtMeasFreeze;

    /**
     * 量测数据类型（默认二次侧值）
     * 1 - 一次侧值；
     * 2 - 二次侧值；
     */
    private int measDataSideType = 2;

    @Override
    public Class<MeasDataCumFreezeCurveBatchGetResponse> getResponseClass() {
        return MeasDataCumFreezeCurveBatchGetResponse.class;
    }

}
