package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.MeasDataCumFreezeCurveGetResponse;
import lombok.*;

import java.math.BigDecimal;
import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@RequiredArgsConstructor
public class MeasDataCumFreezeCurveGetRequest implements BaseRequest<MeasDataCumFreezeCurveGetResponse> {

    private static final long serialVersionUID = 8297055266446815199L;

    /**
     * 量测点标识
     */
    @NonNull
    private Long measPointId;

    /**
     * 量测项编码Set
     */
    @NonNull
    private Set<String> measItemCodeSet;

    /**
     * 量测曲线时间
     */
    @NonNull
    private long gmtMeasFreeze;

    /**
     * 量测数据类型（默认二次侧值）
     * 1 - 一次侧值；
     * 2 - 二次侧值；
     */
    private int measDataSideType = 2;

    @Override
    public Class<MeasDataCumFreezeCurveGetResponse> getResponseClass() {
        return MeasDataCumFreezeCurveGetResponse.class;
    }

}
