package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.MeasDataCumFreezeDayGetRangeResponse;
import lombok.*;

import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@RequiredArgsConstructor
public class MeasDataCumFreezeDayGetRangeRequest implements BaseRequest<MeasDataCumFreezeDayGetRangeResponse> {

    private static final long serialVersionUID = -579638911334849551L;

    /**
     * 量测点标识
     */
    @NonNull
    private Long measPointId;

    /**
     * 量测项编码Set
     */
    @NonNull
    private Set<String> measItemCodeSet;

    /**
     * 量测冻结日期开始值（包括）
     *      格式：yyyy-MM-dd 或 yyyy/MM/dd 或 yyyy.MM.dd 或 yyyyMMdd
     */
    @NonNull
    private String dateMeasFreezeStart;

    /**
     * 量测冻结日期结束值（不包括）
     *      格式：yyyy-MM-dd 或 yyyy/MM/dd 或 yyyy.MM.dd 或 yyyyMMdd
     */
    @NonNull
    private String dateMeasFreezeEnd;

    /**
     * 量测数据类型（默认二次侧值）
     * 1 - 一次侧值；
     * 2 - 二次侧值；
     */
    private int measDataSideType = 2;

    @Override
    public Class<MeasDataCumFreezeDayGetRangeResponse> getResponseClass() {
        return MeasDataCumFreezeDayGetRangeResponse.class;
    }

}
