package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.MeasDataInsDiscreteGetRangeResponse;
import lombok.*;

import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@RequiredArgsConstructor
public class MeasDataInsDiscreteGetRangeRequest implements BaseRequest<MeasDataInsDiscreteGetRangeResponse> {

    private static final long serialVersionUID = -7400161154223634171L;

    /**
     * 量测点标识
     */
    @NonNull
    private Long measPointId;

    /**
     * 量测项编码Set
     */
    @NonNull
    private Set<String> measItemCodeSet;

    /**
     * 量测数据时间开始值（包括）
     */
    @NonNull
    private long gmtMeasDataStart;

    /**
     * 量测数据时间结束值（不包括）
     */
    @NonNull
    private long gmtMeasDataEnd;

    /**
     * 量测数据类型（默认二次侧值）
     * 1 - 一次侧值；
     * 2 - 二次侧值；
     */
    private int measDataSideType = 2;

    @Override
    public Class<MeasDataInsDiscreteGetRangeResponse> getResponseClass() {
        return MeasDataInsDiscreteGetRangeResponse.class;
    }

}
