package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.MeasDataInsFreezeCurveGetRangeResponse;
import lombok.*;

import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@RequiredArgsConstructor
public class MeasDataInsFreezeCurveGetRangeRequest implements BaseRequest<MeasDataInsFreezeCurveGetRangeResponse> {

    private static final long serialVersionUID = 3837445539821222544L;

    /**
     * 量测点标识
     */
    @NonNull
    private Long measPointId;

    /**
     * 量测项编码Set
     */
    @NonNull
    private Set<String> measItemCodeSet;

    /**
     * 量测曲线时间开始值（包括）
     */
    @NonNull
    private long gmtMeasFreezeStart;

    /**
     * 量测曲线时间结束值（不包括）
     */
    @NonNull
    private long gmtMeasFreezeEnd;

    /**
     * 量测数据类型（默认二次侧值）
     * 1 - 一次侧值；
     * 2 - 二次侧值；
     */
    private int measDataSideType = 2;

    @Override
    public Class<MeasDataInsFreezeCurveGetRangeResponse> getResponseClass() {
        return MeasDataInsFreezeCurveGetRangeResponse.class;
    }

}
