package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.MeasDataLatestBatchGetResponse;
import lombok.*;

import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@RequiredArgsConstructor
public class MeasDataLatestBatchGetRequest implements BaseRequest<MeasDataLatestBatchGetResponse> {

    private static final long serialVersionUID = 2863883157289358532L;

    /**
     * 量测点标识Set
     */
    @NonNull
    private Set<Long> measPointIdSet;

    /**
     * 量测项编码Set
     */
    @NonNull
    private Set<String> measItemCodeSet;

    /**
     * 量测数据类型（默认二次侧值）
     * 1 - 一次侧值；
     * 2 - 二次侧值；
     */
    private int measDataSideType = 2;

    /**
     *
     */
    private Long gmtMeasDataLatest;

    @Override
    public Class<MeasDataLatestBatchGetResponse> getResponseClass() {
        return MeasDataLatestBatchGetResponse.class;
    }

}
