package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.MeasDataLatestGetResponse;
import lombok.*;

import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-03-28
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@RequiredArgsConstructor
public class MeasDataLatestGetRequest implements BaseRequest<MeasDataLatestGetResponse> {

    private static final long serialVersionUID = 6449570575057732877L;

    /**
     * 量测点标识
     */
    @NonNull
    private Long measPointId;

    /**
     * 量测项编码Set
     */
    @NonNull
    private Set<String> measItemCodeSet;

    /**
     * 量测数据类型（默认二次侧值）
     * 1 - 一次侧值；
     * 2 - 二次侧值；
     */
    private int measDataSideType = 2;

    /**
     *
     */
    private Long gmtMeasDataLatest;

    @Override
    public Class<MeasDataLatestGetResponse> getResponseClass() {
        return MeasDataLatestGetResponse.class;
    }

}
