package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.MeasStatCumDayBatchGetRangeResponse;
import lombok.*;

import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2022-05-19
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@RequiredArgsConstructor
public class MeasStatCumDayBatchGetRangeRequest implements BaseRequest<MeasStatCumDayBatchGetRangeResponse> {

    private static final long serialVersionUID = 3752365102384059375L;

    /**
     * 量测点标识Set
     */
    @NonNull
    private Set<Long> measPointIdSet;

    /**
     * 量测项编码Set
     */
    @NonNull
    private Set<String> measItemCodeSet;

    /**
     * 统计日期开始值（包括）
     *      格式：yyyy-MM-dd 或 yyyy/MM/dd 或 yyyy.MM.dd 或 yyyyMMdd
     */
    @NonNull
    private String dateMeasStatStart;

    /**
     * 统计日期结束值（不包括）
     *      格式：yyyy-MM-dd 或 yyyy/MM/dd 或 yyyy.MM.dd 或 yyyyMMdd
     */
    @NonNull
    private String dateMeasStatEnd;

    /**
     * 量测数据类型（默认二次侧值）
     * 1 - 一次侧值；
     * 2 - 二次侧值；
     */
    private int measDataSideType = 2;

    /**
     * 曲线间隔，单位分钟（默认值为15），可选项为：15、60、1440
     */
    private int curveInterval = 15;

    @Override
    public Class<MeasStatCumDayBatchGetRangeResponse> getResponseClass() {
        return MeasStatCumDayBatchGetRangeResponse.class;
    }

}
