package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.MeasStatCumDayGetRangeResponse;
import lombok.*;

import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-03
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@RequiredArgsConstructor
public class MeasStatCumDayGetRangeRequest implements BaseRequest<MeasStatCumDayGetRangeResponse> {

    private static final long serialVersionUID = -3676498452437186730L;

    /**
     * 量测点标识
     */
    @NonNull
    private Long measPointId;

    /**
     * 量测项编码Set
     */
    @NonNull
    private Set<String> measItemCodeSet;

    /**
     * 统计日期开始值（包括）
     *      格式：yyyy-MM-dd 或 yyyy/MM/dd 或 yyyy.MM.dd 或 yyyyMMdd
     */
    @NonNull
    private String dateMeasStatStart;

    /**
     * 统计日期结束值（不包括）
     *      格式：yyyy-MM-dd 或 yyyy/MM/dd 或 yyyy.MM.dd 或 yyyyMMdd
     */
    @NonNull
    private String dateMeasStatEnd;

    /**
     * 量测数据类型（默认二次侧值）
     * 1 - 一次侧值；
     * 2 - 二次侧值；
     */
    private int measDataSideType = 2;

    /**
     * 曲线间隔，单位分钟（默认值为15），可选项为：15、60、1440
     */
    private int curveInterval = 15;

    @Override
    public Class<MeasStatCumDayGetRangeResponse> getResponseClass() {
        return MeasStatCumDayGetRangeResponse.class;
    }

}
