package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.MeasStatCumMonthBatchGetRangeResponse;
import lombok.*;

import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2022-05-19
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@RequiredArgsConstructor
public class MeasStatCumMonthBatchGetRangeRequest implements BaseRequest<MeasStatCumMonthBatchGetRangeResponse> {

    private static final long serialVersionUID = -8684702003964808269L;

    /**
     * 量测点标识Set
     */
    @NonNull
    private Set<Long> measPointIdSet;

    /**
     * 量测项编码Set
     */
    @NonNull
    private Set<String> measItemCodeSet;

    /**
     * 统计月份开始值（包括）
     *      格式：yyyy-MM 或 yyyy/MM 或 yyyy.MM 或 yyyyMM
     */
    @NonNull
    private String monthMeasStatStart;

    /**
     * 统计月份结束值（不包括）
     *      格式：yyyy-MM 或 yyyy/MM 或 yyyy.MM 或 yyyyMM
     */
    @NonNull
    private String monthMeasStatEnd;

    /**
     * 量测数据类型（默认二次侧值）
     * 1 - 一次侧值；
     * 2 - 二次侧值；
     */
    private int measDataSideType = 2;

    @Override
    public Class<MeasStatCumMonthBatchGetRangeResponse> getResponseClass() {
        return MeasStatCumMonthBatchGetRangeResponse.class;
    }

}
