package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.MeasStatCumMonthGetResponse;
import lombok.*;

import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-03
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@RequiredArgsConstructor
public class MeasStatCumMonthGetRequest implements BaseRequest<MeasStatCumMonthGetResponse> {

    private static final long serialVersionUID = -2179922815926514105L;

    /**
     * 量测点标识
     */
    @NonNull
    private Long measPointId;

    /**
     * 量测项编码Set
     */
    @NonNull
    private Set<String> measItemCodeSet;

    /**
     * 统计月份
     *      格式：yyyy-MM 或 yyyy/MM 或 yyyy.MM 或 yyyyMM
     */
    @NonNull
    private String monthMeasStat;

    /**
     * 量测数据类型（默认二次侧值）
     * 1 - 一次侧值；
     * 2 - 二次侧值；
     */
    private int measDataSideType = 2;

    @Override
    public Class<MeasStatCumMonthGetResponse> getResponseClass() {
        return MeasStatCumMonthGetResponse.class;
    }

}
