package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.MeasStatInsDayBatchGetResponse;
import lombok.*;

import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-03
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@RequiredArgsConstructor
public class MeasStatInsDayBatchGetRequest implements BaseRequest<MeasStatInsDayBatchGetResponse> {

    private static final long serialVersionUID = -2850958469730413819L;

    /**
     * 量测点标识Set
     */
    @NonNull
    private Set<Long> measPointIdSet;

    /**
     * 量测项编码Set
     */
    @NonNull
    private Set<String> measItemCodeSet;

    /**
     * 统计日期
     *      格式：yyyy-MM-dd 或 yyyy/MM/dd 或 yyyy.MM.dd 或 yyyyMMdd
     */
    @NonNull
    private String dateMeasStat;

    /**
     * 量测数据类型（默认二次侧值）
     * 1 - 一次侧值；
     * 2 - 二次侧值；
     */
    private int measDataSideType = 2;

    @Override
    public Class<MeasStatInsDayBatchGetResponse> getResponseClass() {
        return MeasStatInsDayBatchGetResponse.class;
    }

}
