package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.MeasStatInsDayGetResponse;
import lombok.*;

import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-03
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@RequiredArgsConstructor
public class MeasStatInsDayGetRequest implements BaseRequest<MeasStatInsDayGetResponse> {

    private static final long serialVersionUID = 5218768046844211499L;

    /**
     * 量测点标识
     */
    @NonNull
    private Long measPointId;

    /**
     * 量测项编码Set
     */
    @NonNull
    private Set<String> measItemCodeSet;

    /**
     * 统计日期
     *      格式：yyyy-MM-dd 或 yyyy/MM/dd 或 yyyy.MM.dd 或 yyyyMMdd
     */
    @NonNull
    private String dateMeasStat;

    /**
     * 量测数据类型（默认二次侧值）
     * 1 - 一次侧值；
     * 2 - 二次侧值；
     */
    private int measDataSideType = 2;

    @Override
    public Class<MeasStatInsDayGetResponse> getResponseClass() {
        return MeasStatInsDayGetResponse.class;
    }

}
