package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.MeasStatInsMonthBatchGetResponse;
import lombok.*;

import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2022-05-19
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@RequiredArgsConstructor
public class MeasStatInsMonthBatchGetRequest implements BaseRequest<MeasStatInsMonthBatchGetResponse> {

    private static final long serialVersionUID = 7788746148744455044L;

    /**
     * 量测点标识Set
     */
    @NonNull
    private Set<Long> measPointIdSet;

    /**
     * 量测项编码Set
     */
    @NonNull
    private Set<String> measItemCodeSet;

    /**
     * 统计月份
     *      格式：yyyy-MM 或 yyyy/MM 或 yyyy.MM 或 yyyyMM
     */
    @NonNull
    private String monthMeasStat;

    /**
     * 量测数据类型（默认二次侧值）
     * 1 - 一次侧值；
     * 2 - 二次侧值；
     */
    private int measDataSideType = 2;

    @Override
    public Class<MeasStatInsMonthBatchGetResponse> getResponseClass() {
        return MeasStatInsMonthBatchGetResponse.class;
    }

}
