package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.MeasStatInsMonthGetRangeResponse;
import lombok.*;

import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-03
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@RequiredArgsConstructor
public class MeasStatInsMonthGetRangeRequest implements BaseRequest<MeasStatInsMonthGetRangeResponse> {

    private static final long serialVersionUID = 2512554949138790924L;

    /**
     * 量测点标识
     */
    @NonNull
    private Long measPointId;

    /**
     * 量测项编码Set
     */
    @NonNull
    private Set<String> measItemCodeSet;

    /**
     * 统计月份开始值（包括）
     *      格式：yyyy-MM 或 yyyy/MM 或 yyyy.MM 或 yyyyMM
     */
    @NonNull
    private String monthMeasStatStart;

    /**
     * 统计月份结束值（不包括）
     *      格式：yyyy-MM 或 yyyy/MM 或 yyyy.MM 或 yyyyMM
     */
    @NonNull
    private String monthMeasStatEnd;

    /**
     * 量测数据类型（默认二次侧值）
     * 1 - 一次侧值；
     * 2 - 二次侧值；
     */
    private int measDataSideType = 2;

    @Override
    public Class<MeasStatInsMonthGetRangeResponse> getResponseClass() {
        return MeasStatInsMonthGetRangeResponse.class;
    }

}
