package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.MeasStatInsYearGetRangeResponse;
import lombok.*;

import java.util.Set;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-03
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@RequiredArgsConstructor
public class MeasStatInsYearGetRangeRequest implements BaseRequest<MeasStatInsYearGetRangeResponse> {

    private static final long serialVersionUID = 156616444762572588L;

    /**
     * 量测点标识
     */
    @NonNull
    private Long measPointId;

    /**
     * 量测项编码Set
     */
    @NonNull
    private Set<String> measItemCodeSet;

    /**
     * 统计年份开始值（包括）
     *      格式：yyyy
     */
    @NonNull
    private String yearMeasStatStart;

    /**
     * 统计年份结束值（不包括）
     *      格式：yyyy
     */
    @NonNull
    private String yearMeasStatEnd;

    /**
     * 量测数据类型（默认二次侧值）
     * 1 - 一次侧值；
     * 2 - 二次侧值；
     */
    private int measDataSideType = 2;

    @Override
    public Class<MeasStatInsYearGetRangeResponse> getResponseClass() {
        return MeasStatInsYearGetRangeResponse.class;
    }

}
