package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.entity.*;
import com.easesource.iot.datacenter.openservice.response.NewDevAccessGatewayRegisterResponse;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 *
 * @author Nick Zhang
 * @date 2019-06-06
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class NewDevAccessGatewayRegisterRequest implements BaseRequest<NewDevAccessGatewayRegisterResponse> {

    private static final long serialVersionUID = 5529345686326897319L;

    private DevAccessDo devAccessGatewayParent;
    private DevAccessGatewayDo devAccessGatewayDo;
    private RunAccessGatewayDo runAccessGatewayDo;
    private List<DevAccessDo> devAccessMeasureParentList;
    private List<DevAccessMeasureDo> devAccessMeasureDoList;
    private List<RunMeasPointDo> runMeasPointDoList;

    @Override
    public Class<NewDevAccessGatewayRegisterResponse> getResponseClass() {
        return NewDevAccessGatewayRegisterResponse.class;
    }

}
