package com.easesource.iot.datacenter.openservice.request;

import com.easesource.iot.datacenter.openservice.response.RunAccessGatewayNameAndDescUpdateResponse;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-04
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RunAccessGatewayDeleteFromOrgRequest implements BaseRequest<RunAccessGatewayNameAndDescUpdateResponse> {

    private static final long serialVersionUID = 4442152213394044016L;

    /**
     * 系统单位编号
     *  必填
     */
    private String orgNo;

    /**
     * 接入设备标识 devAccessId
     * 或
     * 接入设备分类编号 devAccessSortNo && 接入设备编号 devAccessNo
     * 或
     * 接入网关设备所属产品 productKey && 接入网关设备客户端标识 clientId
     *
     * 以上三组必须选择一组参数
     *
     */
    private Long devAccessId;
    private String devAccessSortNo;
    private String devAccessNo;
    private String productKey;
    private String clientId;

    @Override
    public Class<RunAccessGatewayNameAndDescUpdateResponse> getResponseClass() {
        return RunAccessGatewayNameAndDescUpdateResponse.class;
    }

}
